package net.danygames2014.tropicraft.entity;

import net.danygames2014.tropicraft.Tropicraft;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_31;
import net.minecraft.class_54;
import net.minecraft.class_57;
import net.minecraft.class_8;
import net.modificationstation.stationapi.api.server.entity.HasTrackingParameters;
import net.modificationstation.stationapi.api.server.entity.MobSpawnDataProvider;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.TriState;

@SuppressWarnings("UnnecessaryBoxing")
@HasTrackingParameters(updatePeriod = 2, sendVelocity = TriState.TRUE, trackingDistance = 30)
public class EIHEntity extends AttackingAnimalEntity implements MobSpawnDataProvider {

    public class_54 observedPlayer;

    public EIHEntity(class_18 world) {
        super(world);
        this.method_1321(1.0F, 3.0F);
    }

    @Override
    public Identifier getHandlerIdentifier() {
        return Tropicraft.NAMESPACE.id("eih");
    }

    @SuppressWarnings("UnnecessaryBoxing")
    @Override
    protected void method_1310() {
        super.method_1310();
        field_1616.method_1502(16, Integer.valueOf(0));
    }

    @Override
    public int method_916() {
        return 1;
    }

    // Behaviour
    @Override
    public void method_1370() {
        super.method_1370();

        /// Stage 1 : Deciding mood
        // If there is no target, get the closest player
        if (observedPlayer == null) {
            observedPlayer = field_1596.method_149(this.field_1600, this.field_1601, this.field_1602, 10D);
        } else if (method_1351(observedPlayer) > 16) {
            observedPlayer = null;
        }

        // If there is a target and the head is not angry, decide if it should be angry
        if (observedPlayer != null && !isAngry()) {
            // If a player gets close, awake
            if (method_1351(observedPlayer) < 10F) {
                setMood(Mood.AWAKE);

                // If a player holds a chunk o' head, become angry
                if (observedPlayer.method_502() != null && observedPlayer.method_502().isOf(Tropicraft.chunkOHead.asItem())) {
                    becomeAngryAt(observedPlayer);
                }
            }

            // If a player gets too close, become angry
            if (method_1351(observedPlayer) < 3F && field_1596.field_213 >= 1) {
                becomeAngryAt(observedPlayer);
            }
        }

        // No Observed Player? Go to sleep
        if (observedPlayer == null) {
            setMood(Mood.SLEEPING);
        }

        // Prevent rotating when sleeping
        if (method_943()) {
            field_1607 = field_1609;
            field_1606 = field_1608;
            this.field_662 = null;
        }
    }

    @Override
    protected boolean method_640() {
        return this.getMood() == Mood.SLEEPING.value;
    }

    @Override
    public boolean method_1355(class_57 damageSource, int amount) {
        if(field_1596.field_180) {
            return false;
        }

        if (damageSource instanceof class_54 player) {
            class_31 heldItem = player.method_502();
            if (heldItem == null || !heldItem.method_714(class_17.field_1883)) {
                field_1596.method_191(this, "tropicraft:entity.eih.laugh", 1.0F, 1.2F / (field_1644.nextFloat() * 0.2F + 0.9F));
            } else {
                super.method_1355(damageSource, amount);
            }
        }

        becomeAngryAt(damageSource);
        return true;
    }

    public void becomeAngryAt(class_57 target) {
        setMood(Mood.ANGRY);
        this.field_662 = target;
    }

    @Override
    protected void method_637(class_57 other, float distance) {
        if (!isAngry()) {
            return;
        }

        super.method_637(other, distance);
    }

    // Mob Drop
    @Override
    protected void method_933() {
        int count = this.field_1644.nextInt(2) + 1;

        for (int i = 0; i < count; ++i) {
            this.method_1327(new class_31(Tropicraft.chunkOHead, 1), 0.0F);
        }
    }

    // Sounds
    @Override
    protected String method_911() {
        if (isAngry()) {
            return field_1644.nextInt(10) == 0 ? "tropicraft:entity.eih.random_long" : null;
        }

        if (isAwake()) {
            return field_1644.nextInt(10) == 0 ? "tropicraft:entity.eih.random_short" : null;
        }

        return null;
    }

    @Override
    protected String method_912() {
        return "tropicraft:entity.eih.hurt";
    }

    @Override
    protected String method_913() {
        return "tropicraft:entity.eih.death";
    }

    // NBT
    @Override
    public void method_1368(class_8 nbt) {
        super.method_1368(nbt);
        nbt.method_1015("Mood", getMood());
    }

    @Override
    public void method_1363(class_8 nbt) {
        super.method_1363(nbt);
        this.setMood(nbt.method_1027("Mood"));
    }

    // Mood
    public void setMood(Mood mood) {
        field_1616.method_1509(16, Integer.valueOf(mood.value));
    }

    public void setMood(int mood) {
        field_1616.method_1509(16, Integer.valueOf(mood));
    }

    public int getMood() {
        return field_1616.method_1508(16);
    }

    public enum Mood {
        SLEEPING(0),
        AWAKE(1),
        ANGRY(2);

        public final int value;

        Mood(int value) {
            this.value = value;
        }

    }

    public boolean method_943(){
        return getMood() == Mood.SLEEPING.value;
    }

    public boolean isAwake(){
        return getMood() == Mood.AWAKE.value;
    }

    public boolean isAngry(){
        return getMood() == Mood.ANGRY.value;
    }
}
