package net.danygames2014.tropicraft.entity;

import net.danygames2014.tropicraft.Tropicraft;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_127;
import net.minecraft.class_18;
import net.minecraft.class_189;
import net.minecraft.class_25;
import net.minecraft.class_26;
import net.minecraft.class_27;
import net.minecraft.class_410;
import net.minecraft.class_54;
import net.minecraft.class_57;
import net.minecraft.class_8;
import net.modificationstation.stationapi.api.server.entity.EntitySpawnDataProvider;
import net.modificationstation.stationapi.api.server.entity.HasTrackingParameters;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.TriState;

import java.util.List;

@HasTrackingParameters(updatePeriod = 2, sendVelocity = TriState.TRUE, trackingDistance = 30)
public class PoisonBlotEntity extends class_410 implements EntitySpawnDataProvider {
    private int inAirTime = 0;

    public PoisonBlotEntity(class_18 world) {
        super(world);
        this.method_1321(0.5F, 0.5F);
        this.field_1631 = 0.0F;
    }

    public PoisonBlotEntity(class_18 world, double x, double y, double z) {
        this(world);
        this.method_1340(x, y, z);
    }

    public PoisonBlotEntity(class_18 world, class_127 owner) {
        this(world);

        this.field_1576 = owner;
        this.method_1341(owner.field_1600, owner.field_1601 + (double) owner.method_1378(), owner.field_1602, owner.field_1606, owner.field_1607);

        this.field_1600 -= class_189.method_646(this.field_1606 / 180.0F * 3.1415927F) * 0.16F;
        this.field_1601 -= 0.1D;
        this.field_1602 -= class_189.method_644(this.field_1606 / 180.0F * 3.1415927F) * 0.16F;
        this.method_1340(this.field_1600, this.field_1601, this.field_1602);

        this.field_1603 = -class_189.method_644(this.field_1606 / 180.0F * 3.1415927F) * class_189.method_646(this.field_1607 / 180.0F * 3.1415927F);
        this.field_1605 = class_189.method_646(this.field_1606 / 180.0F * 3.1415927F) * class_189.method_646(this.field_1607 / 180.0F * 3.1415927F);
        this.field_1604 = -class_189.method_644(this.field_1607 / 180.0F * 3.1415927F);
        this.method_1291(this.field_1603, this.field_1604, this.field_1605, 1.5F, 1.0F);
    }

    public void method_1291(double x, double y, double z, float speed, float divergence) {
        float var9 = class_189.method_642(x * x + y * y + z * z);
        x /= var9;
        y /= var9;
        z /= var9;

        x += this.field_1644.nextGaussian() * 0.0075 * (double) divergence;
        y += this.field_1644.nextGaussian() * 0.0075 * (double) divergence;
        z += this.field_1644.nextGaussian() * 0.0075 * (double) divergence;

        x *= speed;
        y *= speed;
        z *= speed;

        this.field_1603 = x;
        this.field_1604 = y;
        this.field_1605 = z;

        float var10 = class_189.method_642(x * x + z * z);
        this.field_1608 = this.field_1606 = (float) (Math.atan2(x, z) * 180.0 / 3.1415927410125732);
        this.field_1609 = this.field_1607 = (float) (Math.atan2(y, var10) * 180.0 / 3.1415927410125732);
    }

    @Environment(EnvType.CLIENT)
    public void method_1365(double x, double y, double z) {
        this.field_1603 = x;
        this.field_1604 = y;
        this.field_1605 = z;

        if (this.field_1609 == 0.0F && this.field_1608 == 0.0F) {
            this.field_1609 = this.field_1607;
            this.field_1608 = this.field_1606;
            this.method_1341(this.field_1600, this.field_1601, this.field_1602, this.field_1606, this.field_1607);
        }
    }

    public void method_1370() {
        ++this.inAirTime;

        if (this.field_1609 == 0.0F && this.field_1608 == 0.0F) {
            float var1 = class_189.method_642(this.field_1603 * this.field_1603 + this.field_1605 * this.field_1605);
            this.field_1608 = this.field_1606 = (float) (Math.atan2(this.field_1603, this.field_1605) * 180.0 / 3.1415927410125732);
            this.field_1609 = this.field_1607 = (float) (Math.atan2(this.field_1604, var1) * 180.0 / 3.1415927410125732);
        }

        class_26 var16 = class_26.method_1297(this.field_1600, this.field_1601, this.field_1602);
        class_26 var17 = class_26.method_1297(this.field_1600 + this.field_1603, this.field_1601 + this.field_1604, this.field_1602 + this.field_1605);
        class_27 hitResult = this.field_1596.method_162(var16, var17, false, true);
        var16 = class_26.method_1297(this.field_1600, this.field_1601, this.field_1602);
        var17 = class_26.method_1297(this.field_1600 + this.field_1603, this.field_1601 + this.field_1604, this.field_1602 + this.field_1605);
        if (hitResult != null) {
            var17 = class_26.method_1297(hitResult.field_1988.field_1585, hitResult.field_1988.field_1586, hitResult.field_1988.field_1587);
        }

        class_57 var4 = null;
        List entities = this.field_1596.method_211(this, this.field_1610.method_86(this.field_1603, this.field_1604, this.field_1605).method_93(1.0, 1.0, 1.0));
        double var6 = 0.0;

        for (Object object : entities) {
            class_57 entity = (class_57) object;
            if (entity.method_1356() && (entity != this.field_1576 || this.inAirTime >= 5)) {
                class_25 var11 = entity.field_1610.method_93(0.3F, 0.3F, 0.3F);
                class_27 var12 = var11.method_89(var16, var17);
                if (var12 != null) {
                    double var13 = var16.method_1294(var12.field_1988);
                    if (var13 < var6 || var6 == 0.0) {
                        var4 = entity;
                        var6 = var13;
                    }
                }
            }
        }

        if (var4 != null) {
            hitResult = new class_27(var4);
        }

        if (hitResult != null) {
            if (hitResult.field_1989 != null) {
                if (hitResult.field_1989.method_1355(this.field_1576, 4)) {
                    //this.world.playSound(this, "random.drr", 1.0F, 1.2F / (this.random.nextFloat() * 0.2F + 0.9F));
                    this.method_1386();
                } else {
                    this.field_1603 *= -0.10000000149011612;
                    this.field_1604 *= -0.10000000149011612;
                    this.field_1605 *= -0.10000000149011612;
                    this.field_1606 += 180.0F;
                    this.field_1608 += 180.0F;
                    this.inAirTime = 0;
                }
            } else {
                this.method_1386();
            }
        }

        this.field_1600 += this.field_1603;
        this.field_1601 += this.field_1604;
        this.field_1602 += this.field_1605;
        this.field_1606 = (float) (Math.atan2(this.field_1603, this.field_1605) * 180.0 / 3.1415927410125732);

        while (this.field_1607 - this.field_1609 >= 180.0F) {
            this.field_1609 += 360.0F;
        }

        while (this.field_1606 - this.field_1608 < -180.0F) {
            this.field_1608 -= 360.0F;
        }

        while (this.field_1606 - this.field_1608 >= 180.0F) {
            this.field_1608 += 360.0F;
        }

        this.field_1607 = this.field_1609 + (this.field_1607 - this.field_1609) * 0.2F;
        this.field_1606 = this.field_1608 + (this.field_1606 - this.field_1608) * 0.2F;

        if (this.method_1334()) {
            this.method_1386();
        }

        this.field_1603 *= 0.99F;
        this.field_1604 *= 0.99F;
        this.field_1605 *= 0.99F;
        this.field_1604 -= 0.03F;
        this.method_1340(this.field_1600, this.field_1601, this.field_1602);
    }

    public void method_1368(class_8 nbt) {
    }

    public void method_1363(class_8 nbt) {
    }

    @Override
    public void method_1354(class_54 player) {
        // We are not picking up poison from the ground :-)
    }

    @Override
    public Identifier getHandlerIdentifier() {
        return Tropicraft.NAMESPACE.id("poison_blot");
    }
}
