package net.danygames2014.tropicraft.entity.renderer;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_127;
import net.minecraft.class_173;
import net.minecraft.class_245;
import org.lwjgl.opengl.GL11;

@Environment(EnvType.CLIENT)
public class TropiEntityRenderer extends class_245 {
    public String texture;

    public TropiEntityRenderer(class_173 model, float shadowRadius, String texture) {
        super(model, shadowRadius);
        this.texture = texture;
    }

    public void method_822(class_127 entity, double x, double y, double z, float g, float delta) {
        GL11.glPushMatrix();
        GL11.glDisable(GL11.GL_CULL_FACE);

        this.field_909.field_1427 = this.method_820(entity, delta);
        if (this.field_910 != null) {
            this.field_910.field_1427 = this.field_909.field_1427;
        }

        this.field_909.field_1428 = entity.method_1360();
        if (this.field_910 != null) {
            this.field_910.field_1428 = this.field_909.field_1428;
        }

        try {
            // Calculate Rotation
            float bodyYaw = entity.field_1013 + (entity.field_1012 - entity.field_1013) * delta;
            float headYaw = entity.field_1608 + (entity.field_1606 - entity.field_1608) * delta;
            float headPitch = entity.field_1609 + (entity.field_1607 - entity.field_1609) * delta;

            // "Set Rendering Position in World"
            GL11.glTranslated(x,y,z);

            float animationProgress = this.method_828(entity, delta);
            this.method_824(entity, animationProgress, bodyYaw, delta);
            float scale = 0.0625F;
            GL11.glEnable(32826);
            GL11.glScalef(-1.0F, -1.0F, 1.0F);
            this.method_823(entity, delta); // preRender

            GL11.glTranslatef(0.0F, -0.06F, 0.0F);

//            GL11.glTranslatef(0.0F, -24.0F * scale - 0.0078125F, 0.0F);
//            GL11.glTranslatef(0.0F, -2.0F, 0.0F);

            float nextLimbDistance = entity.field_1048 + (entity.field_1049 - entity.field_1048) * delta;
            float nextLimbAngle = entity.field_1050 - entity.field_1049 * (1.0F - delta);
            if (nextLimbDistance > 1.0F) {
                nextLimbDistance = 1.0F;
            }

            this.method_2026(this.texture);

            GL11.glEnable(GL11.GL_ALPHA_TEST);
            this.field_909.method_1209(entity, nextLimbAngle, nextLimbDistance, delta);
            this.field_909.method_1210(nextLimbAngle, nextLimbDistance, animationProgress, headYaw - bodyYaw, headPitch, scale);
            this.field_909.method_1211(nextLimbAngle, nextLimbDistance, animationProgress, headYaw - bodyYaw, headPitch, scale);

//            for(int layer = 0; layer < 4; ++layer) {
//                if (this.method_825(entity, layer, delta)) { // renderOuterLayer
//                    this.field_910.render(nextLimbAngle, nextLimbDistance, animationProgress, headYaw - bodyYaw, headPitch, scale);
//                    GL11.glDisable(GL11.GL_BLEND);
//                    GL11.glEnable(GL11.GL_ALPHA_TEST);
//                }
//            }
//
//            this.method_827(entity, delta); // renderPlayerEffects
            float brightness = entity.method_1394(delta);
            int color = this.method_817(entity, brightness, delta); // getColor

            // Hurt Animation Rendering
            if ((color >> 24 & 255) > 0 || entity.field_1038 > 0 || entity.field_1041 > 0) {
                GL11.glDisable(GL11.GL_TEXTURE_2D);
                GL11.glDisable(GL11.GL_ALPHA_TEST);
                GL11.glEnable(GL11.GL_BLEND);
                GL11.glBlendFunc(770, 771);
                GL11.glDepthFunc(514);
                if (entity.field_1038 > 0 || entity.field_1041 > 0) {
                    GL11.glColor4f(brightness, 0.0F, 0.0F, 0.4F);
                    this.field_909.method_1211(nextLimbAngle, nextLimbDistance, animationProgress, headYaw - bodyYaw, headPitch, scale);

//                    for(int layer = 0; layer < 4; ++layer) {
//                        if (this.method_819(entity, layer, delta)) { // renderLayer
//                            GL11.glColor4f(brightness, 0.0F, 0.0F, 0.4F);
//                            this.field_910.render(nextLimbAngle, nextLimbDistance, animationProgress, headYaw - bodyYaw, headPitch, scale);
//                        }
//                    }
                }

                if ((color >> 24 & 255) > 0) {
                    float red = (float)(color >> 16 & 255) / 255.0F;
                    float green = (float)(color >> 8 & 255) / 255.0F;
                    float blue = (float)(color & 255) / 255.0F;
                    float alpha = (float)(color >> 24 & 255) / 255.0F;
                    GL11.glColor4f(red, green, blue, alpha);
                    this.field_909.method_1211(nextLimbAngle, nextLimbDistance, animationProgress, headYaw - bodyYaw, headPitch, scale);

//                    for(int layer = 0; layer < 4; ++layer) {
//                        if (this.method_819(entity, layer, delta)) { // renderLayer
//                            GL11.glColor4f(red, green, blue, alpha);
//                            this.field_910.render(nextLimbAngle, nextLimbDistance, animationProgress, headYaw - bodyYaw, headPitch, scale);
//                        }
//                    }
                }

                GL11.glDepthFunc(515);
                GL11.glDisable(GL11.GL_BLEND);
                GL11.glEnable(GL11.GL_ALPHA_TEST);
                GL11.glEnable(GL11.GL_TEXTURE_2D);
            }

            GL11.glDisable(32826);
        } catch (Exception e) {
            e.printStackTrace();
        }

        GL11.glEnable(GL11.GL_CULL_FACE);
        GL11.glPopMatrix();
        this.method_821(entity, x, y, z); // Render Entity Name
    }
}
