package net.danygames2014.tropicraft.item;

import net.danygames2014.tropicraft.entity.Dyeable;
import net.minecraft.class_18;
import net.minecraft.class_242;
import net.minecraft.class_31;
import net.minecraft.class_54;
import net.minecraft.class_57;
import net.modificationstation.stationapi.api.template.item.TemplateItem;
import net.modificationstation.stationapi.api.util.Identifier;

public class DyeableSpawnerItem extends TemplateItem {
    public Class<? extends class_57> spawnedEntity;

    public DyeableSpawnerItem(Identifier identifier, Class<? extends class_57> spawnedEntity) {
        super(identifier);
        this.spawnedEntity = spawnedEntity;
    }

    @Override
    public boolean method_444(class_31 stack, class_54 user, class_18 world, int xPos, int yPos, int zPos, int side) {
        if (world.field_180) {
            return true;
        }

        double x = xPos;
        double y = yPos;
        double z = zPos;


        try {
            // Create Entity
            class_57 entity = spawnedEntity.getDeclaredConstructor(class_18.class).newInstance(world);

            System.out.println(entity.field_1633);

            // Determine coordinates according to block side
            switch (side) {
                case 0: // BOTTOM (Y--)
                    y -= entity.field_1633;
                    break;
                case 1: // TOP (Y++)
                    y += (Math.max(entity.field_1633, 0.5F) + 1F);
                    x += 0.5;
                    z += 0.5;
                    break;
                case 2: // SIDE (Z--)
                    z -= 0.5;
                    x += 0.5;
                    break;
                case 3: // SIDE (Z++)
                    z += 1.5;
                    x += 0.5;
                    break;
                case 4: // SIDE (X--)
                    x -= 0.5;
                    z += 0.5;
                    break;
                case 5: // SIDE (X++)
                    x += 1.5;
                    z += 0.5;
                    break;
                default:
                    y++;
                    break;
            }

            // Set the Entity position
            entity.method_1340(x, y, z);

            // Spawn the Entity
            world.method_210(entity);

            // Dye the entity
            dyeEntity(stack, entity);

            stack.field_751--;
            return true;

        } catch (Exception ignored) {
            return false;
        }
    }

    public void dyeEntity(class_31 stack, class_57 entity) {
        if (entity instanceof Dyeable dyeable && !entity.field_1596.field_180) {
            dyeable.setColor(class_242.field_908[stack.method_722()]);
        }
    }

}
