package net.danygames2014.tropicraft.mixin;

import net.danygames2014.tropicraft.item.EntityInteractor;
import net.minecraft.class_127;
import net.minecraft.class_18;
import net.minecraft.class_31;
import net.minecraft.class_54;
import net.minecraft.class_57;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_54.class)
public abstract class PlayerEntityMixin extends class_127 {

    @Shadow
    public abstract class_31 getHand();

    public PlayerEntityMixin(class_18 world) {
        super(world);
    }

    @Inject(method = "interact", at = @At(value = "HEAD"), cancellable = true)
    public void interactWithEntity(class_57 entity, CallbackInfo ci) {
        class_31 stack = this.getHand();
        if (stack != null && stack.method_694() instanceof EntityInteractor interactor) {
            interactor.interactWithEntity(stack, entity, class_54.class.cast(this));
            ci.cancel();
        }
    }

    @Inject(method = "attack", at = @At(value = "HEAD"), cancellable = true)
    public void attackEntity(class_57 entity, CallbackInfo ci) {
        class_31 stack = this.getHand();
        if (stack != null && stack.method_694() instanceof EntityInteractor interactor) {
            if (!interactor.attackEntity(stack, entity, class_54.class.cast(this))) {
                ci.cancel();
            }
        }
    }
}
