package net.danygames2014.tropicraft.mixin.scalearmor;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import net.danygames2014.tropicraft.Tropicraft;
import net.minecraft.class_127;
import net.minecraft.class_136;
import net.minecraft.class_54;
import net.minecraft.class_57;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_54.class)
public class PlayerEntityMixin extends LivingEntityMixin {
    @Shadow
    public class_136 inventory;

    @Unique
    public boolean wearingScaleArmorSet;

    @Inject(method = "tick", at = @At(value = "HEAD"))
    public void scaleArmorFireImmune(CallbackInfo ci) {
        // If the player is already fire immune we do not need to carry out this expensive check
        if (this.fireImmune) {
            return;
        }

        if (inventory.field_746[0] == null || inventory.field_746[1] == null || inventory.field_746[2] == null || inventory.field_746[3] == null) {
            this.wearingScaleArmorSet = false;
        } else {
            this.wearingScaleArmorSet = inventory.field_746[0].isOf(Tropicraft.scaleBoots) && inventory.field_746[1].isOf(Tropicraft.scaleLeggings) && inventory.field_746[2].isOf(Tropicraft.scaleChestplate) && inventory.field_746[3].isOf(Tropicraft.scaleHelmet);
        }
    }

    @Override
    public boolean living_baseTick(class_127 instance, Operation<Boolean> original) {
        return original.call(instance) || wearingScaleArmorSet;
    }

    @Override
    public boolean entity_baseTick(class_57 instance, Operation<Boolean> original) {
        return original.call(instance) || wearingScaleArmorSet;
    }

    @Override
    public boolean entity_setOnFire(class_57 instance, Operation<Boolean> original) {
        return original.call(instance) || wearingScaleArmorSet;
    }

    @Override
    public boolean entity_damage(class_57 instance, Operation<Boolean> original) {
        return original.call(instance) || wearingScaleArmorSet;
    }
}
