package net.danygames2014.tropicraft.world.feature;

import net.danygames2014.tropicraft.Tropicraft;
import net.minecraft.class_18;
import net.minecraft.class_239;
import net.minecraft.class_339;
import java.util.Random;

import static net.danygames2014.tropicraft.Tropicraft.WORLDGEN_CONFIG;

public class BambooPatchFeature extends class_239 {
    @Override
    public boolean method_1142(class_18 world, Random random, int xPos, int yPos, int zPos) {
        int x = xPos + 8;
        int z = zPos + 8;
        int y = world.method_222(x, z);

        // If the block isn't air, return
        if (!world.getBlockState(x, y, z).isAir()) {
            return false;
        }

        // Calculate the amount and spread used for this patch
        int amount = random.nextInt(WORLDGEN_CONFIG.bamboo.maxBambooCount - WORLDGEN_CONFIG.bamboo.minBambooCount) + WORLDGEN_CONFIG.bamboo.minBambooCount;
        int spread = random.nextInt(3) - 1 + (int) (Math.sqrt(amount) / 2.0);

        // Spawn <amount> bamboo stalks
        for (int l = 0; l < amount; ++l) {
            int bambooX = x + random.nextInt(spread);
            int bambooZ = z + random.nextInt(spread);
            int bambooY = world.method_222(bambooX, bambooZ) - 1;
            int height = random.nextInt(WORLDGEN_CONFIG.bamboo.maxBambooHeight - WORLDGEN_CONFIG.bamboo.minBambooHeight) + WORLDGEN_CONFIG.bamboo.minBambooHeight;
            class_339 pos = new class_339(bambooX, bambooY, bambooZ);
            for (int h = 0; h < height; ++h) {
                pos = pos.up();
                // If the block isn't air or bamboo can't grow on it, continue
                if (!world.getBlockState(pos.field_2100, pos.field_2101, pos.field_2102).isAir() || !Tropicraft.bambooShootBlock.method_1566(world, pos.field_2100, pos.field_2101, pos.field_2102)) {
                    break;
                    //continue; This should probably not continue
                }
                world.setBlockState(pos.field_2100, pos.field_2101, pos.field_2102, Tropicraft.bambooShootBlock.getDefaultState());
            }
        }
        return true;
    }
}
