/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.tropicraft.block.bamboochest;

import net.danygames2014.tropicraft.block.bamboochest.ChestType;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_339;
import net.minecraft.class_54;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.item.ItemPlacementContext;
import net.modificationstation.stationapi.api.state.StateManager;
import net.modificationstation.stationapi.api.state.property.EnumProperty;
import net.modificationstation.stationapi.api.state.property.Properties;
import net.modificationstation.stationapi.api.state.property.Property;
import net.modificationstation.stationapi.api.template.block.TemplateChestBlock;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.math.Direction;

public class BambooChestBlock
extends TemplateChestBlock {
    public static final EnumProperty<ChestType> CHEST_TYPE = EnumProperty.of((String)"chest_type", ChestType.class);
    public static final class_339[] offsets = new class_339[]{new class_339(0, 0, 1), new class_339(0, 0, -1), new class_339(1, 0, 0), new class_339(-1, 0, 0)};

    public BambooChestBlock(Identifier identifier) {
        super(identifier);
    }

    public void appendProperties(StateManager.Builder<class_17, BlockState> builder) {
        super.appendProperties(builder);
        try {
            builder.add(new Property[]{Properties.HORIZONTAL_FACING});
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        builder.add(new Property[]{CHEST_TYPE});
    }

    public BlockState getPlacementState(ItemPlacementContext context) {
        return (BlockState)((BlockState)this.getDefaultState().with((Property)Properties.HORIZONTAL_FACING, (Comparable)context.getHorizontalPlayerFacing().getOpposite())).with(CHEST_TYPE, (Comparable)((Object)ChestType.SINGLE));
    }

    public void method_1611(class_18 world, int x, int y, int z) {
        super.method_1611(world, x, y, z);
        this.checkChestConnection(world, x, y, z);
    }

    public void method_1609(class_18 world, int x, int y, int z, int id) {
        super.method_1609(world, x, y, z, id);
        this.checkChestConnection(world, x, y, z);
    }

    public boolean method_1608(class_18 world, int x, int y, int z, class_54 player) {
        this.checkChestConnection(world, x, y, z);
        return super.method_1608(world, x, y, z, player);
    }

    public void checkChestConnection(class_18 world, int x, int y, int z) {
        BlockState state = world.getBlockState(x, y, z);
        block6: for (class_339 offset : offsets) {
            BlockState otherState = world.getBlockState(x + offset.field_2100, y + offset.field_2101, z + offset.field_2102);
            if (!this.canConnectTo(world, x, y, z, otherState)) continue;
            switch ((Direction)state.get((Property)Properties.HORIZONTAL_FACING)) {
                case EAST: {
                    if (offset.field_2100 == -1) {
                        world.setBlockState(x, y, z, (BlockState)state.with(CHEST_TYPE, (Comparable)((Object)ChestType.LEFT)));
                        continue block6;
                    }
                    if (offset.field_2100 != 1) continue block6;
                    world.setBlockState(x, y, z, (BlockState)state.with(CHEST_TYPE, (Comparable)((Object)ChestType.RIGHT)));
                    continue block6;
                }
                case WEST: {
                    if (offset.field_2100 == 1) {
                        world.setBlockState(x, y, z, (BlockState)state.with(CHEST_TYPE, (Comparable)((Object)ChestType.LEFT)));
                        continue block6;
                    }
                    if (offset.field_2100 != -1) continue block6;
                    world.setBlockState(x, y, z, (BlockState)state.with(CHEST_TYPE, (Comparable)((Object)ChestType.RIGHT)));
                    continue block6;
                }
                case NORTH: {
                    if (offset.field_2102 == 1) {
                        world.setBlockState(x, y, z, (BlockState)state.with(CHEST_TYPE, (Comparable)((Object)ChestType.LEFT)));
                        continue block6;
                    }
                    if (offset.field_2102 != -1) continue block6;
                    world.setBlockState(x, y, z, (BlockState)state.with(CHEST_TYPE, (Comparable)((Object)ChestType.RIGHT)));
                    continue block6;
                }
                case SOUTH: {
                    if (offset.field_2102 == -1) {
                        world.setBlockState(x, y, z, (BlockState)state.with(CHEST_TYPE, (Comparable)((Object)ChestType.LEFT)));
                        continue block6;
                    }
                    if (offset.field_2102 != 1) continue block6;
                    world.setBlockState(x, y, z, (BlockState)state.with(CHEST_TYPE, (Comparable)((Object)ChestType.RIGHT)));
                }
            }
        }
    }

    public boolean canConnectTo(class_18 world, int x, int y, int z, BlockState otherChest) {
        BlockState state = world.getBlockState(x, y, z);
        return state.isOf((class_17)this) && otherChest.isOf((class_17)this) && state.get((Property)Properties.HORIZONTAL_FACING) == otherChest.get((Property)Properties.HORIZONTAL_FACING);
    }
}

