/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.tropicraft.entity;

import java.util.List;
import net.danygames2014.tropicraft.Tropicraft;
import net.danygames2014.tropicraft.entity.AttackingAnimalEntity;
import net.danygames2014.tropicraft.util.MathHelper;
import net.minecraft.class_18;
import net.minecraft.class_31;
import net.minecraft.class_54;
import net.minecraft.class_57;
import net.minecraft.class_8;
import net.modificationstation.stationapi.api.server.entity.HasTrackingParameters;
import net.modificationstation.stationapi.api.server.entity.MobSpawnDataProvider;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.TriState;

@HasTrackingParameters(updatePeriod=2, sendVelocity=TriState.TRUE, trackingDistance=30)
public class IguanaEntity
extends AttackingAnimalEntity
implements MobSpawnDataProvider {
    public float tailAngle1;
    public float tailAngle2;
    public float tailAngle3;
    public static float TAIL_ANIMATION_SPEED = 1.0f;
    public float tailAnimationMultiplier = 1.0f;
    public int angerLevel;

    public IguanaEntity(class_18 world) {
        super(world);
        this.method_1321(0.5f, 0.5f);
        this.field_1615 = true;
        this.field_1009 = 10;
    }

    public IguanaEntity(class_18 world, Double x, Double y, Double z) {
        this(world);
    }

    public Identifier getHandlerIdentifier() {
        return Tropicraft.NAMESPACE.id("iguana");
    }

    public void method_1370() {
        super.method_1370();
        if (this.angerLevel > 0) {
            --this.angerLevel;
        }
        this.animateTail();
    }

    protected void method_1374(double heightDifference, boolean onGround) {
    }

    public boolean method_1355(class_57 damageSource, int amount) {
        if (this.field_1596.field_180) {
            return false;
        }
        if (damageSource instanceof class_54) {
            List nearbyEntities = this.field_1596.method_211((class_57)this, this.field_1610.method_93(32.0, 32.0, 32.0));
            for (class_57 entity : nearbyEntities) {
                if (!(entity instanceof IguanaEntity)) continue;
                IguanaEntity iguana = (IguanaEntity)entity;
                iguana.becomeAngryAt(damageSource);
            }
            this.becomeAngryAt(damageSource);
        }
        return super.method_1355(damageSource, amount);
    }

    public void becomeAngryAt(class_57 entity) {
        this.field_662 = entity;
        this.angerLevel = 400 + this.field_1644.nextInt(400);
    }

    @Override
    protected void method_637(class_57 other, float distance) {
        if (this.angerLevel <= 0) {
            this.field_662 = null;
            return;
        }
        super.method_637(other, distance);
    }

    public void animateTail() {
        this.tailAnimationMultiplier = TAIL_ANIMATION_SPEED;
        if (this.field_1603 > 0.05 || this.field_1605 > 0.05) {
            this.tailAnimationMultiplier = TAIL_ANIMATION_SPEED * 0.2f;
            this.tailAngle1 = MathHelper.pushBack(this.tailAngle1, 80.0f, 100.0f, 2.5f);
        }
        this.tailAngle1 = MathHelper.cycleClampUp(this.tailAngle1, 1.2f * this.tailAnimationMultiplier, 360.0f);
        this.tailAngle2 = MathHelper.cycleClampUp(this.tailAngle2, 1.5f * this.tailAnimationMultiplier, 360.0f);
        this.tailAngle2 = MathHelper.pushBack(this.tailAngle2, this.tailAngle1 - 15.0f, this.tailAngle1 + 15.0f);
        this.tailAngle3 = MathHelper.cycleClampUp(this.tailAngle3, 1.7f * this.tailAnimationMultiplier, 360.0f);
        this.tailAngle3 = MathHelper.pushBack(this.tailAngle3, this.tailAngle2 - 15.0f, this.tailAngle2 + 15.0f);
    }

    protected void method_933() {
        int count = this.field_1644.nextInt(3) + 1;
        for (int i = 0; i < count; ++i) {
            this.method_1327(new class_31(Tropicraft.scale, 1), 0.0f);
        }
    }

    protected String method_911() {
        return "tropicraft:entity.iguana.random";
    }

    protected String method_912() {
        return "tropicraft:entity.iguana.hurt";
    }

    protected String method_913() {
        return "tropicraft:entity.iguana.death";
    }

    protected float method_915() {
        return 0.4f;
    }

    public void method_1368(class_8 nbt) {
        super.method_1368(nbt);
        nbt.method_1015("Anger", this.angerLevel);
    }

    public void method_1363(class_8 nbt) {
        super.method_1363(nbt);
        this.angerLevel = nbt.method_1027("Anger");
    }
}

