/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.tropicraft.world.structure;

import java.util.ArrayList;
import java.util.Random;
import net.danygames2014.tropicraft.Tropicraft;
import net.danygames2014.tropicraft.world.structure.CollisionType;
import net.danygames2014.tropicraft.world.structure.Rotation;
import net.danygames2014.tropicraft.world.structure.StructureBlockEntry;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.modificationstation.stationapi.api.block.BlockState;

public class Structure {
    public ArrayList<StructureBlockEntry> blocks = new ArrayList();
    public Random random;

    public Structure(class_18 world) {
        this.random = world.field_214;
    }

    public boolean addBlock(StructureBlockEntry entry) {
        return this.blocks.add(entry);
    }

    public boolean addBlock(int xOffset, int yOffset, int zOffset, BlockState state, CollisionType collisionType) {
        return this.addBlock(new StructureBlockEntry(xOffset, yOffset, zOffset, state, collisionType));
    }

    public boolean addBlock(int xOffset, int yOffset, int zOffset, BlockState state) {
        return this.addBlock(new StructureBlockEntry(xOffset, yOffset, zOffset, state));
    }

    public boolean addBlock(int xOffset, int yOffset, int zOffset, class_17 block, CollisionType collisionType) {
        return this.addBlock(new StructureBlockEntry(xOffset, yOffset, zOffset, block, collisionType));
    }

    public boolean addBlock(int xOffset, int yOffset, int zOffset, class_17 block) {
        return this.addBlock(new StructureBlockEntry(xOffset, yOffset, zOffset, block));
    }

    public boolean checkCollision(class_18 world, int x, int y, int z) {
        for (StructureBlockEntry block : this.blocks) {
            if (this.isReplaceable(world, x + block.xOffset, y + block.yOffset, z + block.zOffset) || block.collisionType != CollisionType.DONT_GENERATE) continue;
            return false;
        }
        return true;
    }

    public boolean generate(class_18 world, int x, int y, int z) {
        return this.generate(world, x, y, z, Rotation.NONE);
    }

    public boolean generate(class_18 world, int x, int y, int z, Rotation rotation) {
        if (!this.checkCollision(world, x, y, z)) {
            return false;
        }
        for (StructureBlockEntry block : this.blocks) {
            this.placeBlock(world, x, y, z, block, rotation);
        }
        return true;
    }

    public boolean placeBlock(class_18 world, int x, int y, int z, StructureBlockEntry block) {
        return this.placeBlock(world, x, y, z, block, Rotation.NONE);
    }

    public boolean placeBlock(class_18 world, int x, int y, int z, StructureBlockEntry block, Rotation rotation) {
        if (rotation.swapXZ) {
            return this.placeState(world, x + block.zOffset * rotation.getXMultiplier(), y + block.yOffset, z + block.xOffset * rotation.getZMultiplier(), block.getState(this, world, x, y, z, block), block.collisionType);
        }
        return this.placeState(world, x + block.xOffset * rotation.getXMultiplier(), y + block.yOffset, z + block.zOffset * rotation.getZMultiplier(), block.getState(this, world, x, y, z, block), block.collisionType);
    }

    public boolean placeState(class_18 world, int x, int y, int z, BlockState state, CollisionType collisionType) {
        if (this.isReplaceable(world, x, y, z)) {
            world.setBlockState(x, y, z, state);
            return true;
        }
        if (collisionType == CollisionType.REPLACE_BLOCK) {
            world.setBlockState(x, y, z, state);
            return true;
        }
        return false;
    }

    public boolean isReplaceable(class_18 world, int x, int y, int z) {
        return world.getBlockState(x, y, z).isAir() || world.method_1779(x, y, z).method_896() || world.getBlockState(x, y, z).isOf(Tropicraft.palmSapling);
    }
}

