package net.danygames2014.tropicraft.block.bamboochest;

import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_339;
import net.minecraft.class_54;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.item.ItemPlacementContext;
import net.modificationstation.stationapi.api.state.StateManager;
import net.modificationstation.stationapi.api.state.property.EnumProperty;
import net.modificationstation.stationapi.api.state.property.Properties;
import net.modificationstation.stationapi.api.template.block.TemplateChestBlock;
import net.modificationstation.stationapi.api.util.Identifier;

public class BambooChestBlock extends TemplateChestBlock {
    public static final EnumProperty<ChestType> CHEST_TYPE = EnumProperty.of("chest_type", ChestType.class);

    public static final class_339[] offsets = new class_339[]{
            new class_339(0, 0, 1),
            new class_339(0, 0, -1),
            new class_339(1, 0, 0),
            new class_339(-1, 0, 0)
    };

    public BambooChestBlock(Identifier identifier) {
        super(identifier);
    }

    @Override
    public void appendProperties(StateManager.Builder<class_17, BlockState> builder) {
        super.appendProperties(builder);
        // If this fails, another mod (probably VBE) already registered a facing property on the Chest Block itself
        try {
            builder.add(Properties.HORIZONTAL_FACING);
        } catch (IllegalArgumentException ignored) {
            
        }
        
        builder.add(CHEST_TYPE);
    }

    @Override
    public BlockState getPlacementState(ItemPlacementContext context) {
        return this.getDefaultState().with(Properties.HORIZONTAL_FACING, context.getHorizontalPlayerFacing().getOpposite()).with(CHEST_TYPE, ChestType.SINGLE);
    }

    @Override
    public void method_1611(class_18 world, int x, int y, int z) {
        super.method_1611(world, x, y, z);
        this.checkChestConnection(world, x, y, z);
    }

    @Override
    public void method_1609(class_18 world, int x, int y, int z, int id) {
        super.method_1609(world, x, y, z, id);
        this.checkChestConnection(world, x, y, z);
    }

    @Override
    public boolean method_1608(class_18 world, int x, int y, int z, class_54 player) {
        this.checkChestConnection(world, x, y, z);
        return super.method_1608(world, x, y, z, player);
    }

    public void checkChestConnection(class_18 world, int x, int y, int z) {
        BlockState state = world.getBlockState(x, y, z);
        for (class_339 offset : offsets) {
            BlockState otherState = world.getBlockState(x + offset.field_2100, y + offset.field_2101, z + offset.field_2102);
            if (canConnectTo(world, x, y, z, otherState)) {
                switch (state.get(Properties.HORIZONTAL_FACING)) {
                    case EAST:
                        if (offset.field_2100 == -1) {
                            world.setBlockState(x, y, z, state.with(CHEST_TYPE, ChestType.LEFT));
                        } else if (offset.field_2100 == 1) {
                            world.setBlockState(x, y, z, state.with(CHEST_TYPE, ChestType.RIGHT));
                        }
                        break;

                    case WEST:
                        if (offset.field_2100 == 1) {
                            world.setBlockState(x, y, z, state.with(CHEST_TYPE, ChestType.LEFT));
                        } else if (offset.field_2100 == -1) {
                            world.setBlockState(x, y, z, state.with(CHEST_TYPE, ChestType.RIGHT));
                        }
                        break;

                    case NORTH:
                        if (offset.field_2102 == 1) {
                            world.setBlockState(x, y, z, state.with(CHEST_TYPE, ChestType.LEFT));
                        } else if (offset.field_2102 == -1) {
                            world.setBlockState(x, y, z, state.with(CHEST_TYPE, ChestType.RIGHT));
                        }
                        break;

                    case SOUTH:
                        if (offset.field_2102 == -1) {
                            world.setBlockState(x, y, z, state.with(CHEST_TYPE, ChestType.LEFT));
                        } else if (offset.field_2102 == 1) {
                            world.setBlockState(x, y, z, state.with(CHEST_TYPE, ChestType.RIGHT));
                        }
                        break;
                }
            }
        }
    }

    public boolean canConnectTo(class_18 world, int x, int y, int z, BlockState otherChest) {
        BlockState state = world.getBlockState(x, y, z);
        if (state.isOf(this) && otherChest.isOf(this)) {
            if (state.get(Properties.HORIZONTAL_FACING) == otherChest.get(Properties.HORIZONTAL_FACING)) {
                return true; //otherChest.get(CHEST_TYPE) == ChestType.SINGLE;
            }
        }
        return false;
    }
}
