package net.danygames2014.tropicraft.block.sifter;

import net.danygames2014.tropicraft.Tropicraft;
import net.danygames2014.tropicraft.recipe.SiftingRecipeOutput;
import net.danygames2014.tropicraft.recipe.SiftingRecipeRegistry;
import net.minecraft.class_142;
import net.minecraft.class_31;
import net.minecraft.class_55;
import net.minecraft.class_8;

public class SifterBlockEntity extends class_55 {
    public int siftTimeRemaining;

    public class_31 siftedItem;
    public class_142 renderedItem;

    public double yaw = 0.0D;
    public double yaw2 = 0.0D;

    public SifterBlockEntity() {
        this.siftTimeRemaining = -1;
        this.siftedItem = null;
    }

    @Override
    public void method_1076() {
        if (siftTimeRemaining > 0) {
            siftTimeRemaining--;
        }

        this.yaw2 = this.yaw2 % 360.0D;
        this.yaw += 4.545454502105713D;

        if (siftTimeRemaining == 0) {
            finishSifting();
        }
    }

    public boolean sift(class_31 item) {
        if (siftTimeRemaining == -1 && item != null && SiftingRecipeRegistry.hasRecipe(item.method_694())) {
            siftedItem = item;
            siftedItem.field_751 = 1;
            siftTimeRemaining = SiftingRecipeRegistry.getRecipe(item.method_694()).siftingTime;
            return true;
        }
        return false;
    }

    public void finishSifting() {
        if(!field_1238.field_180){
            for (SiftingRecipeOutput output : SiftingRecipeRegistry.getRecipe(siftedItem.method_694()).outputs) {
                if (field_1238.field_214.nextInt(output.chance) == 0) {
                    // Thank you mine_diver for helping me figure out a bug here
                    field_1238.method_210(new class_142(field_1238, field_1239, field_1240+1, field_1241, output.stack.method_724()));
                }
            }
        }

        renderedItem = null;
        siftedItem = null;
        siftTimeRemaining = -1;
    }

    @Override
    public void method_1078(class_8 nbt) {
        super.method_1078(nbt);
        nbt.method_1015("siftTimeRemaining", siftTimeRemaining);
        if (siftTimeRemaining >= 0) {
            nbt.method_1018("siftedItem", siftedItem.method_706(new class_8()));
        }
    }

    @Override
    public void method_1077(class_8 nbt) {
        super.method_1077(nbt);
        siftTimeRemaining = nbt.method_1027("siftTimeRemaining");
        if (siftTimeRemaining >= 0) {
            siftedItem = new class_31(nbt.method_1033("siftedItem"));
        }
    }
}
