package net.danygames2014.tropicraft.entity;

import net.danygames2014.tropicraft.Tropicraft;
import net.danygames2014.tropicraft.mixin.LivingEntityAccessor;
import net.danygames2014.tropicraft.util.ColorHelper;
import net.danygames2014.tropicraft.util.MathHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_18;
import net.minecraft.class_25;
import net.minecraft.class_31;
import net.minecraft.class_54;
import net.minecraft.class_57;
import net.minecraft.class_8;
import net.modificationstation.stationapi.api.network.packet.MessagePacket;
import net.modificationstation.stationapi.api.server.entity.EntitySpawnDataProvider;
import net.modificationstation.stationapi.api.server.entity.HasTrackingParameters;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.TriState;

@SuppressWarnings("UnnecessaryBoxing")
@HasTrackingParameters(updatePeriod = 4, sendVelocity = TriState.TRUE, trackingDistance = 30)
public class BeachChairEntity extends class_57 implements EntitySpawnDataProvider, Dyeable {
    public BeachChairEntity(class_18 world) {
        super(world);
        this.method_1321(0.8F, 0.8F);
        this.field_1631 = this.field_1633 / 2.0F;
        //this.setColor(ColorHelper.getColor(random.nextFloat(), random.nextFloat(), random.nextFloat()));
    }

    public BeachChairEntity(class_18 world, Double x, Double y, Double z) {
        this(world);
        this.method_1340(x, y, z);
    }

    @Override
    public void method_1370() {
        super.method_1370();
        if (!field_1596.field_180) {
            // If on ground, allow the chair jumping code to run
            if (this.field_1623) {
                if (this.field_1594 != null && this.field_1594 instanceof class_54 player) {
                    LivingEntityAccessor playerA = (LivingEntityAccessor) player;
                    if (playerA.jumping()) {
                        System.out.println("JUMP");
                        System.out.println(playerA.rightMovement());
                        System.out.println(playerA.frontMovement());
                        if (playerA.rightMovement() > 0.9F) {
                            this.field_1606 -= field_1644.nextFloat(5.0F, 10.0F);
                            this.method_1322(0, 0.2D, 0);
                        } else if (playerA.rightMovement() < -0.9F) {
                            this.field_1606 += field_1644.nextFloat(5.0F, 10.0F);
                            this.method_1322(0, 0.2D, 0);
                        }
                    }
                }
            }

            // If not on ground apply some gravity
            if (!this.field_1623) { // onGround
                this.method_1322(0, -0.07d, 0);
            }

            // If on ground, lower the velocity
            if (this.field_1623) {
                this.field_1603 *= 0.7F;
                this.field_1605 *= 0.7F;

                if (Math.abs(this.field_1603) < 0.05F) {
                    this.field_1603 = 0F;
                }

                if (Math.abs(this.field_1605) < 0.05F) {
                    this.field_1605 = 0F;
                }
            }


            // Cap the velocity at 0.5d on each axis
            this.field_1603 = MathHelper.clamp(this.field_1603, -0.5, 0.5);
            this.field_1604 = MathHelper.clamp(this.field_1604, -0.5, 0.5);
            this.field_1605 = MathHelper.clamp(this.field_1605, -0.5, 0.5);

            // Move
            this.method_1371(this.field_1603, this.field_1604, this.field_1605);
        }
    }

    @Override
    protected boolean method_1358() {
        return true;
    }

    @Override
    public class_25 method_1381() {
        return this.field_1610;
    }

    @Override
    public class_25 method_1379(class_57 other) {
        return this.field_1610;
    }

    @Override
    public boolean method_1380() {
        return true;
    }

    @Override
    public double method_1357() {
        return -0.2125D;
    }

    @Override
    public boolean method_1356() {
        return !this.field_1630;
    }

    @Override
    public void method_1382() {
        if (this.field_1594 == null) {
            return;
        }

        double xOffset = -Math.sin(this.field_1606 * (Math.PI / 180)) * 0.4;
        double zOffset = Math.cos(this.field_1606 * (Math.PI / 180)) * 0.4;

        this.field_1594.method_1340(this.field_1600 + xOffset, this.field_1601 + this.method_1357() + this.field_1594.method_1385(), this.field_1602 + zOffset);
    }

    @Override
    public boolean method_1323(class_54 player) {
        if (this.field_1594 != null && this.field_1594 instanceof class_54 && this.field_1594 != player) {
            return true;
        }
        if (!this.field_1596.field_180 && !player.method_1373()) {
            player.method_1376(this);
        }

        if (player.method_1373()) {
            player.method_490(FabricLoader.getInstance().getEnvironmentType().name() + " Color: " + this.getColor());
        }
        return true;
    }

    @Override
    public boolean method_1355(class_57 damageSource, int amount) {
        if (!field_1596.field_180) {
            this.method_1327(new class_31(Tropicraft.bambooStickItem, 1), 0.1F);
            this.method_1327(new class_31(Tropicraft.bambooStickItem, 1), 0.3F);
            this.method_1327(new class_31(Tropicraft.bambooStickItem, 1), 0.25F);
        }
        this.method_1386();
        return true;
    }

    @Override
    public int getColor() {
        return this.field_1616.method_1508(16);
    }

    @Override
    public void setColor(int color) {
        if (!this.field_1596.field_180) {
            this.field_1616.method_1509(16, Integer.valueOf(color));
        }
    }

    @Override
    protected void method_1310() {
        this.field_1616.method_1502(16, Integer.valueOf(0));
    }

    @Override
    protected void method_1363(class_8 nbt) {
        if (nbt.method_1023("color")) {
            this.setColor(nbt.method_1027("color"));
        } else {
            this.setColor(ColorHelper.getColor(field_1644.nextFloat(), field_1644.nextFloat(), field_1644.nextFloat()));
        }
    }

    @Override
    protected void method_1368(class_8 nbt) {
        nbt.method_1015("color", this.getColor());
    }

    @Override
    public void writeToMessage(MessagePacket message) {
        message.ints = new int[]{
            message.ints[0],
            message.ints[1],
            message.ints[2],
            message.ints[3],
            message.ints[4],
            this.getColor()
        };
    }

    @Override
    public void readFromMessage(MessagePacket message) {
        this.field_1616.method_1509(16, Integer.valueOf(message.ints[5]));
    }

    @Override
    public Identifier getHandlerIdentifier() {
        return Tropicraft.NAMESPACE.id("beach_chair");
    }
}
