package net.danygames2014.tropicraft.entity;

import net.danygames2014.tropicraft.Tropicraft;
import net.minecraft.class_18;
import net.minecraft.class_31;
import net.minecraft.class_54;
import net.minecraft.class_57;
import net.minecraft.class_8;
import net.modificationstation.stationapi.api.server.entity.HasTrackingParameters;
import net.modificationstation.stationapi.api.server.entity.MobSpawnDataProvider;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.TriState;

import java.util.List;

import static net.danygames2014.tropicraft.util.MathHelper.cycleClampUp;
import static net.danygames2014.tropicraft.util.MathHelper.pushBack;

@HasTrackingParameters(updatePeriod = 2, sendVelocity = TriState.TRUE, trackingDistance = 30)
public class IguanaEntity extends AttackingAnimalEntity implements MobSpawnDataProvider {
    public float tailAngle1;
    public float tailAngle2;
    public float tailAngle3;

    public static float TAIL_ANIMATION_SPEED = 1.0F;
    public float tailAnimationMultiplier = 1.0F;

    public int angerLevel;

    public IguanaEntity(class_18 world) {
        super(world);
        this.method_1321(0.5F, 0.5F);
        this.field_1615 = true;
        this.field_1009 = 10;
    }

    @SuppressWarnings("unused")
    public IguanaEntity(class_18 world, Double x, Double y, Double z) {
        this(world);
    }

    @Override
    public Identifier getHandlerIdentifier() {
        return Tropicraft.NAMESPACE.id("iguana");
    }

    // Behaviour
    @Override
    public void method_1370() {
        super.method_1370();

        if(angerLevel > 0){
            angerLevel--;
        }

        animateTail();
    }

    @Override
    protected void method_1374(double heightDifference, boolean onGround) {
        // Negates fall damage
    }

    @SuppressWarnings("unchecked")
    @Override
    public boolean method_1355(class_57 damageSource, int amount) {
        if (field_1596.field_180) {
            return false;
        }

        if (damageSource instanceof class_54) {
            List<class_57> nearbyEntities = this.field_1596.method_211(this, this.field_1610.method_93(32.0D, 32.0D, 32.0D));

            for (class_57 entity : nearbyEntities) {
                if (entity instanceof IguanaEntity iguana) {
                    iguana.becomeAngryAt(damageSource);
                }
            }

            this.becomeAngryAt(damageSource);
        }
        return super.method_1355(damageSource, amount);
    }

    public void becomeAngryAt(class_57 entity) {
        this.field_662 = entity;
        this.angerLevel = 400 + this.field_1644.nextInt(400);
    }

    @Override
    protected void method_637(class_57 other, float distance) {
        if (this.angerLevel <= 0) {
            this.field_662 = null;
            return;
        }

        super.method_637(other, distance);
    }

    // Animations
    public void animateTail() {
        tailAnimationMultiplier = TAIL_ANIMATION_SPEED;

        if (this.field_1603 > 0.05D || this.field_1605 > 0.05D) {
            tailAnimationMultiplier = TAIL_ANIMATION_SPEED * 0.2F;
            tailAngle1 = pushBack(tailAngle1, 80F, 100F, 2.5F);
        }

        tailAngle1 = cycleClampUp(tailAngle1, (1.2F * tailAnimationMultiplier), 360F);

        tailAngle2 = cycleClampUp(tailAngle2, (1.5F * tailAnimationMultiplier), 360F);
        tailAngle2 = pushBack(tailAngle2, tailAngle1 - 15F, tailAngle1 + 15F);

        tailAngle3 = cycleClampUp(tailAngle3, (1.7F * tailAnimationMultiplier), 360F);
        tailAngle3 = pushBack(tailAngle3, tailAngle2 - 15F, tailAngle2 + 15F);
    }

    // Mob Drop
    @Override
    protected void method_933() {
        int count = this.field_1644.nextInt(3) + 1;

        for (int i = 0; i < count; ++i) {
            this.method_1327(new class_31(Tropicraft.scale, 1), 0.0F);
        }
    }

    // Sounds
    @Override
    protected String method_911() {
        return "tropicraft:entity.iguana.random";
    }

    @Override
    protected String method_912() {
        return "tropicraft:entity.iguana.hurt";
    }

    @Override
    protected String method_913() {
        return "tropicraft:entity.iguana.death";
    }

    @Override
    protected float method_915() {
        return 0.4F;
    }

    // NBT
    @Override
    public void method_1368(class_8 nbt) {
        super.method_1368(nbt);
        nbt.method_1015("Anger", this.angerLevel);
    }

    @Override
    public void method_1363(class_8 nbt) {
        super.method_1363(nbt);
        this.angerLevel = nbt.method_1027("Anger");
    }
}
