package net.danygames2014.tropicraft.entity;

import net.danygames2014.tropicraft.Tropicraft;
import net.minecraft.class_114;
import net.minecraft.class_18;
import net.minecraft.class_189;
import net.minecraft.class_57;
import net.modificationstation.stationapi.api.registry.BlockRegistry;
import net.modificationstation.stationapi.api.server.entity.HasTrackingParameters;
import net.modificationstation.stationapi.api.server.entity.MobSpawnDataProvider;
import net.modificationstation.stationapi.api.tag.TagKey;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.TriState;

import static net.danygames2014.tropicraft.util.MathHelper.distance;
import static net.danygames2014.tropicraft.world.feature.FlowerPatchFeature.flowers;

@HasTrackingParameters(updatePeriod = 2, sendVelocity = TriState.TRUE, trackingDistance = 30)
public class TropiCreeperEntity extends class_114 implements MobSpawnDataProvider {
    public TropiCreeperEntity(class_18 world) {
        super(world);
        this.method_1321(0.9F, 1.3F);
    }

    @Override
    public String method_1314() {
        return "/assets/tropicraft/stationapi/textures/entity/tropicreeper/tropicreeper.png";
    }

    @Override
    public void method_637(class_57 other, float distance) {
        if (!this.field_1596.field_180) {
            int fuseSpeed = this.method_413();
            if (fuseSpeed <= 0 && distance < 3.0F || fuseSpeed > 0 && distance < 7.0F) {
                if (this.field_350 == 0) {
                    this.field_1596.method_191(this, "tropicraft:entity.tropicreeper.fuse", 1.0F, 1.0F);
                }

                this.method_411(1);
                ++this.field_350;
                if (this.field_350 >= 30) {
                    this.explode(field_1596, this, class_189.method_645(this.field_1600), class_189.method_645(this.field_1601), class_189.method_645(this.field_1602), method_412());
                    this.method_1386();
                }

                this.field_663 = true;
            } else {
                this.method_411(-1);
                --this.field_350;
                if (this.field_350 < 0) {
                    this.field_350 = 0;
                }
            }

        }
    }

    @SuppressWarnings("unused")
    public void explode(class_18 world, class_57 entity, int x, int y, int z, boolean charged) {
        for (int xOffset = -3; xOffset < 4; xOffset++) {
            for (int zOffset = -3; zOffset < 4; zOffset++) {
                for (int yOffset = -2; yOffset < 3; yOffset++) {
                    if (!world.getBlockState(x + xOffset, y + yOffset, z + zOffset).isAir()) {
                        continue;
                    }

                    if (!world.getBlockState(x + xOffset, (y + yOffset) - 1, z + zOffset).isIn(TagKey.of(BlockRegistry.INSTANCE.getKey(), Tropicraft.NAMESPACE.id("flower_grows_on")))) {
                        continue;
                    }

                    if (distance(x, y, z, x + xOffset, y + yOffset, z + zOffset) > 3.6D) {
                        continue;
                    }

                    if (field_1644.nextInt(3) == 0) {
                        world.setBlockStateWithNotify(x + xOffset, y + yOffset, z + zOffset, flowers[field_1644.nextInt(0, 16)]);
                    }
                }
            }
        }
    }

    @Override
    public Identifier getHandlerIdentifier() {
        return Tropicraft.NAMESPACE.id("tropicreeper");
    }
}
