package net.danygames2014.tropicraft.entity.model;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_173;
import net.minecraft.class_189;

@Environment(EnvType.CLIENT)
public class FrogModel extends class_173 {
    public TropiModelPart body = new TropiModelPart(28,8);
    public TropiModelPart frontRightLeg = new TropiModelPart(12,14);
    public TropiModelPart frontLeftLeg = new TropiModelPart(12,19);
    public TropiModelPart rearRightLeg = new TropiModelPart(0,16);
    public TropiModelPart rearLeftLeg = new TropiModelPart(0,8);
    public TropiModelPart rightEye = new TropiModelPart(0,0,true);
    public TropiModelPart leftEye = new TropiModelPart(0,4, true);

    public FrogModel() {
        body.addCube(-2,4,1,4,9,4,0,3,4);
        body.field_2295 = (float) (Math.PI / 2F);
        frontRightLeg.addCube(0,0,-6,4,1,4,1,1,-3);
        frontLeftLeg.addCube(-4,0,-6,4,1,4,-1,1,-3);
        rearRightLeg.addCube(2,0,1,3,5,3,2,4,2);
        rearLeftLeg.addCube(-5,0,1,3,5,3,-2,4,2);
        rightEye.addCube(1,4,-3,2,2,2,2,4,-2);
        leftEye.addCube(-3,4,-3,2,2,2,-2,4,-2);
    }

    @Override
    public void method_1211(float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch, float scale) {
        body.method_1815(scale);
        frontRightLeg.method_1815(scale);
        frontLeftLeg.method_1815(scale);
        rearRightLeg.method_1815(scale);
        rearLeftLeg.method_1815(scale);
        rightEye.method_1815(scale);
        leftEye.method_1815(scale);
    }

    @Override
    public void method_1210(float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch, float scale) {
        frontRightLeg.field_2295 = class_189.method_646(limbAngle * 0.6662f) * 1.4f * limbDistance;
        frontLeftLeg.field_2295 = class_189.method_646(limbAngle * 0.6662f) * 1.4f * limbDistance;
        rearRightLeg.field_2295 = class_189.method_646(limbAngle * 0.6662f + 3.141593f) * 1.4f * limbDistance;
        rearLeftLeg.field_2295 = class_189.method_646(limbAngle * 0.6662f + 3.141593f) * 1.4f * limbDistance;
    }
}
