package net.danygames2014.tropicraft.entity.model;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_163;
import net.minecraft.class_189;

@Environment(EnvType.CLIENT)
public class TropiModelPart extends class_163 {

    public float defaultPitch;
    public float defaultYaw;
    public float defaultRoll;
    public float defaultPivotX;
    public float defaultPivotZ;

    public TropiModelPart(int u, int v, boolean mirror) {
        super(u, v);
        this.defaultPitch = this.field_2295 = 0.0F;
        this.defaultYaw = this.field_2296 = 0.0F;
        this.defaultRoll = this.field_2297 = 0.0F;
        this.field_2298 = mirror;
    }

    public TropiModelPart(int u, int v) {
        this(u, v, false);
    }

    public void addCube(float x, float y, float z, int sizeX, int sizeY, int sizeZ, float pivotX, float pivotY, float pivotZ) {
        y = -y;
        pivotY = -pivotY;

        x -= pivotX;
        y -= pivotY;
        z -= pivotZ;

        y -= sizeY - 1;

        this.method_1817(x, y, z, sizeX, sizeY, sizeZ);
        this.method_1816(pivotX, pivotY, pivotZ);

        this.defaultPivotX = pivotX;
        this.defaultPivotZ = pivotZ;
    }

    public void angleHead(float headPitch, float headYaw) {
        this.field_2295 = headPitch * 0.01745328627F;
        this.field_2296 = headYaw * 0.01745328627F;
    }

    public void angleLeg(float limbAngle, float limbDistance, boolean invertMovement) {
        if (invertMovement) {
            this.field_2295 = class_189.method_646(limbAngle * 0.6662F + 3.1415927F) * 1.4F * limbDistance;
            return;
        }
        this.field_2295 = class_189.method_646(limbAngle * 0.6662F) * 1.4F * limbDistance;
    }

    public void angleLeg(float limbAngle, float limbDistance) {
        this.angleLeg(limbAngle, limbDistance, false);
    }
}
