package net.danygames2014.tropicraft.world.dimension;

import net.danygames2014.tropicraft.init.BiomeListener;
import net.minecraft.class_153;
import net.minecraft.class_18;
import net.minecraft.class_515;
import net.minecraft.class_519;
import java.util.Arrays;
import java.util.Random;

public class TropicsBiomeSource extends class_519 {
    private final TropiNoiseSampler noiseSampler;

    public TropicsBiomeSource(class_18 world) {
        super(world);
        this.noiseSampler = new TropiNoiseSampler(new Random(world.method_254()), 7);
    }

    @Override
    public class_153 method_1789(class_515 chunkPos) {
        return this.method_1787(chunkPos.field_2378 << 4, chunkPos.field_2379 << 4);
    }

    double lowest = Double.MAX_VALUE;
    double highest = Double.MIN_VALUE;

    @Override
    public class_153 method_1787(int x, int z) {
        double sample = noiseSampler.samplePoint(x, z, 0.25D, 0.25D);

        if (sample <= lowest) {
            System.out.println("LOWEST: " + lowest + " | HIGHEST: " + highest);
            lowest = sample;
        }

        if (sample >= highest) {
            System.out.println("LOWEST: " + lowest + " | HIGHEST: " + highest);
            highest = sample;
        }

        if (sample <= -38D) {
            return BiomeListener.TROPICS_ISLAND;
        } else if (sample <= -17D) {
            return BiomeListener.TROPICS_DEEP_OCEAN;
        } else if (sample <= -0.39D) {
            return BiomeListener.TROPICS_OCEAN;
        } else if (sample <= 0.4D) {
            return BiomeListener.TROPICS_DUNES;
        } else {
            return BiomeListener.TROPICS;
        }
    }

    @Override
    public double method_1786(int x, int z) {
        return 1.0F;
    }

    @Override
    public double[] method_1790(double[] temperatures, int x, int z, int width, int depth) {
        if (temperatures == null || temperatures.length < width * depth)
            temperatures = new double[width * depth];
        Arrays.fill(temperatures, 0, width * depth, 1.0F);
        return temperatures;
    }

    @Override
    public class_153[] method_1791(class_153[] biomes, int x, int z, int width, int depth) {
        if (biomes == null || biomes.length < width * depth) {
            biomes = new class_153[width * depth];
        }

        if (field_2235 == null || biomes.length < width * depth) {
            field_2235 = new double[width * depth];
            field_2236 = new double[width * depth];
        }

        Arrays.fill(biomes, 0, width * depth, BiomeListener.TROPICS);

        return biomes;
    }
}
