package net.danygames2014.unitweaks.mixin.bugfixes.fencelightingfix;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.danygames2014.unitweaks.UniTweaks;
import net.minecraft.class_13;
import net.minecraft.class_14;
import net.minecraft.class_17;
import net.minecraft.class_229;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_13.class)
public class BlockRenderManagerMixin {
    // This is to reduce the amount of instanceof checks from 4 to 1
    @Unique
    public boolean isFence = false;

    @WrapOperation(method = "renderSmooth", at = @At(value = "INVOKE", target = "Lnet/minecraft/block/Block;getLuminance(Lnet/minecraft/world/BlockView;III)F", ordinal = 7))
    public float luminance1(class_17 block, class_14 blockView, int x, int y, int z, Operation<Float> original) {
        isFence = block instanceof class_229 && UniTweaks.BUGFIXES_CONFIG.fenceLightingFix;

        if (isFence) {
            return original.call(block, blockView, x, y + 1, z);
        }
        return original.call(block, blockView, x, y, z);
    }

    @WrapOperation(method = "renderSmooth", at = @At(value = "INVOKE", target = "Lnet/minecraft/block/Block;getLuminance(Lnet/minecraft/world/BlockView;III)F", ordinal = 8))
    public float luminance2(class_17 block, class_14 blockView, int x, int y, int z, Operation<Float> original) {
        if (isFence) {
            return original.call(block, blockView, x, y + 1, z);
        }
        return original.call(block, blockView, x, y, z);
    }

    @WrapOperation(method = "renderSmooth", at = @At(value = "INVOKE", target = "Lnet/minecraft/block/Block;getLuminance(Lnet/minecraft/world/BlockView;III)F", ordinal = 9))
    public float luminance3(class_17 block, class_14 blockView, int x, int y, int z, Operation<Float> original) {
        if (isFence) {
            return original.call(block, blockView, x, y + 1, z);
        }
        return original.call(block, blockView, x, y, z);
    }

    @WrapOperation(method = "renderSmooth", at = @At(value = "INVOKE", target = "Lnet/minecraft/block/Block;getLuminance(Lnet/minecraft/world/BlockView;III)F", ordinal = 10))
    public float luminance4(class_17 block, class_14 blockView, int x, int y, int z, Operation<Float> original) {
        if (isFence) {
            return original.call(block, blockView, x, y + 1, z);
        }
        return original.call(block, blockView, x, y, z);
    }


}
