package net.danygames2014.unitweaks.tweaks.photomode;

import net.danygames2014.unitweaks.util.ModOptions;
import net.minecraft.class_260;
import net.minecraft.class_32;
import net.minecraft.class_33;
import net.minecraft.class_564;
import net.minecraft.class_597;
import net.minecraft.client.Minecraft;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SuppressWarnings("unchecked")
public class PhotoModeScreen extends class_32 {
    private class_33 rotateLeftButton;
    private class_33 rotateRightButton;
    private class_597 timeSlider;
    private class_33 screenshotButton;
    private class_33 exitButton;
    private class_597 tiltSlider;
    private long originalTOD;
    private long desiredTOD = -1L;
    private long desiredDay = -1L;
    boolean shouldScreenshot = false;
    public float rotation = 0.0f;
    public float rotationGoal = 0.0f;
    public float zoom = 1.0f;
    public float zoomGoal = 1.0f;
    public float tilt = 30.0f;
    public float tiltGoal = 30.0f;
    public class_32 previousScreen;

    public PhotoModeScreen(class_32 previousScreen) {
        this.previousScreen = previousScreen;
    }

    @Override
    public void method_119() {
        super.method_119();
        this.exitButton = new class_33(5, 0, 0, 20, 20, "X");
        this.rotateLeftButton = new class_33(0, this.field_152 / 2 - 49 - 2 - 20, this.field_153 - 20, 20, 20, "<");
        this.rotateRightButton = new class_33(1, this.field_152 / 2 + 49 + 2, this.field_153 - 20, 20, 20, ">");
        this.screenshotButton = new class_33(4, this.field_152 / 2 - 49, this.field_153 - 20, 98, 20, "Take Screenshot");
        this.tiltSlider = new SliderWidgetWithoutSaving(7, this.field_152 - 151, 0, "Tilt: Default", 0.33333334f);
        this.timeSlider = new SliderWidgetWithoutSaving(2, this.field_152 - 151, 20, "Time of Day: Current", 0.0f);

        this.field_154.add(this.tiltSlider);
        this.field_154.add(this.rotateLeftButton);
        this.field_154.add(this.rotateRightButton);
        this.field_154.add(this.screenshotButton);
        this.field_154.add(this.exitButton);
        if (!this.field_151.field_2804.field_180) {
            this.field_154.add(this.timeSlider);
        }

        this.originalTOD = this.field_151.field_2804.method_256();
        if (this.desiredTOD == -1L) {
            this.desiredTOD = this.originalTOD % 24000L;
        } else {
            this.timeSlider.field_2591 = (float) this.desiredTOD / 24000.0f;
        }
        if (this.desiredDay == -1L) {
            this.desiredDay = this.originalTOD / 24000L;
        }
        this.updateButtonsText();
        ModOptions.photoModeFogMultiplier = 100F;
    }

    @Override
    public void method_133() {
        this.field_151.field_2804.method_159(this.originalTOD);
        ModOptions.photoModeFogMultiplier = 1.0F;
    }

    @Override
    protected void method_120(class_33 ButtonWidget2) {
        if (ButtonWidget2 == this.rotateLeftButton) {
            this.rotationGoal += 0.5f;
        } else if (ButtonWidget2 == this.rotateRightButton) {
            this.rotationGoal -= 0.5f;
        } else if (ButtonWidget2 == this.screenshotButton) {
            this.shouldScreenshot = true;
        } else if (ButtonWidget2 == this.exitButton) {
            this.field_151.method_2112(this.previousScreen);
        }
        this.updateButtonsText();
    }

    @Override
    public void method_118(int n2, int n3, float f) {
        class_564 scaledResolution = new class_564(this.field_151.field_2824, this.field_151.field_2802, this.field_151.field_2803);

        GL11.glViewport(0, 0, this.field_151.field_2802, this.field_151.field_2803);
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        GL11.glMatrixMode(5888);
        GL11.glLoadIdentity();
        GL11.glClear(256);
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        GL11.glOrtho(0.0, scaledResolution.method_1857(), scaledResolution.method_1858(), 0.0, 1000.0, 3000.0);
        GL11.glMatrixMode(5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef(0.0f, 0.0f, -2000.0f);

        if (this.zoom != this.zoomGoal) {
            this.zoom += (this.zoomGoal - this.zoom) * 0.02f + (this.zoomGoal - this.zoom) * 0.02f * f;
            if (Math.abs(this.zoom - this.zoomGoal) < 5.0E-4f) {
                this.zoom = this.zoomGoal;
            }
        }
        if (this.rotation != this.rotationGoal) {
            this.rotation += (this.rotationGoal - this.rotation) * 0.02f + (this.rotationGoal - this.rotation) * 0.02f * f;
            if (Math.abs(this.rotation - this.rotationGoal) < 5.0E-4f) {
                this.rotation = this.rotationGoal;
            }
        }
        if (this.tilt != this.tiltGoal) {
            this.tilt += (this.tiltGoal - this.tilt) * 0.02f + (this.tiltGoal - this.tilt) * 0.02f * f;
            if (Math.abs(this.tilt - this.tiltGoal) < 0.01f) {
                this.tilt = this.tiltGoal;
            }
        }
        if (!this.shouldScreenshot) {
            super.method_118(n2, n3, f);
        } else {
            class_260.method_908(Minecraft.method_2123(), this.field_151.field_2802, this.field_151.field_2803);
            this.shouldScreenshot = false;
        }
        this.scroll(Mouse.getDWheel());

        if (this.timeSlider.field_2592) {
            long var4 = (long) (this.timeSlider.field_2591 * 24000.0F);
            if (this.timeSlider.field_2591 == 0.0F) {
                this.desiredTOD = this.originalTOD % 24000L;
            } else {
                this.desiredTOD = var4;
            }

            this.field_151.field_2804.method_159(this.desiredDay + this.desiredTOD);
            this.field_151.field_2804.method_237();
//            this.minecraft.world.method_232();
            this.field_151.field_2805.method_1148();
            this.updateButtonsText();
        }

        if (this.tiltSlider.field_2592) {
            this.tiltGoal = (float) ((int) (this.tiltSlider.field_2591 * 90.0F));
            this.updateButtonsText();
        }
    }

    private void updateButtonsText() {
        this.timeSlider.field_1372 = this.timeSlider.field_2591 == 0.0f ? "Time of Day: Default" : "Time of Day: " + (long) (this.timeSlider.field_2591 * 24000.0f);
        this.tiltSlider.field_1372 = (int) (this.tiltSlider.field_2591 * 90.0f) == 30 ? "Tilt: Default" : "Tilt: " + (Math.floor(this.tiltSlider.field_2591 * 90.0f)) + " degrees";
    }

    public void scroll(int direction) {
        if (direction < 0) {
            this.zoomGoal -= 0.25f;
        } else if (direction > 0) {
            this.zoomGoal += 0.25f;
        }
    }
}
