package net.danygames2014.unitweaks.mixin.bugfixes.fenceboundingboxfix;

import net.danygames2014.unitweaks.UniTweaks;
import net.minecraft.class_13;
import net.minecraft.class_14;
import net.minecraft.class_17;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_13.class)
public abstract class BlockRenderManagerMixin {

    @Shadow
    public abstract boolean renderBlock(class_17 block, int x, int y, int z);

    @Shadow
    private class_14 blockView;

    @Unique
    boolean connectedPosX;
    @Unique
    boolean connectedNegX;
    @Unique
    boolean connectedNegZ;
    @Unique
    boolean connectedPosZ;

    @Unique
    boolean connectedX;
    @Unique
    boolean connectedZ;

    @Unique
    float minX;
    @Unique
    float maxX;
    @Unique
    float minZ;
    @Unique
    float maxZ;

    // I know this is not good
    @Inject(method = "renderFence", at = @At(value = "HEAD"), cancellable = true)
    public void renderConnectedFence(class_17 block, int x, int y, int z, CallbackInfoReturnable<Boolean> cir) {
        if (UniTweaks.TWEAKS_CONFIG.fencesConnectBlocks) {
            block.method_1578(0.375F, 0.0F, 0.375F, 0.625F, 1.0F, 0.625F);
            this.renderBlock(block, x, y, z);

            connectedPosX = (this.blockView.method_1780(x + 1, y, z) || this.blockView.method_1776(x + 1, y, z) == class_17.field_1902.field_1915) && this.blockView.method_1776(x + 1, y, z) != class_17.field_1906.field_1915;
            connectedNegX = (this.blockView.method_1780(x - 1, y, z) || this.blockView.method_1776(x - 1, y, z) == class_17.field_1902.field_1915) && this.blockView.method_1776(x - 1, y, z) != class_17.field_1906.field_1915;
            connectedNegZ = (this.blockView.method_1780(x, y, z - 1) || this.blockView.method_1776(x, y, z - 1) == class_17.field_1902.field_1915) && this.blockView.method_1776(x, y, z - 1) != class_17.field_1906.field_1915;
            connectedPosZ = (this.blockView.method_1780(x, y, z + 1) || this.blockView.method_1776(x, y, z + 1) == class_17.field_1902.field_1915) && this.blockView.method_1776(x, y, z + 1) != class_17.field_1906.field_1915;

            connectedX = connectedPosX || connectedNegX;
            connectedZ = connectedPosZ || connectedNegZ;

            if (!connectedX && !connectedZ) {
                connectedX = true;
            }

            minX = connectedNegX ? 0.0F : 0.4375F;
            maxX = connectedPosX ? 1.0F : 0.5625F;
            minZ = connectedNegZ ? 0.0F : 0.4375F;
            maxZ = connectedPosZ ? 1.0F : 0.5625F;

            if (connectedX) {
                block.method_1578(minX, 0.75F, 0.4375F, maxX, 0.9375F, 0.5625F);
                this.renderBlock(block, x, y, z);
            }

            if (connectedZ) {
                block.method_1578(0.4375F, 0.75F, minZ, 0.5625F, 0.9375F, maxZ);
                this.renderBlock(block, x, y, z);
            }

            if (connectedX) {
                block.method_1578(minX, 0.375F, 0.4375F, maxX, 0.5625F, 0.5625F);
                this.renderBlock(block, x, y, z);
            }

            if (connectedZ) {
                block.method_1578(0.4375F, 0.375F, minZ, 0.5625F, 0.5625F, maxZ);
                this.renderBlock(block, x, y, z);
            }

            block.method_1578(0.0F, 0.0F, 0.0F, 1.0F, 1.0F, 1.0F);
            cir.setReturnValue(true);
        }
    }
}
