package net.danygames2014.unitweaks.mixin.tweaks.cloudheight;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.danygames2014.unitweaks.UniTweaks;
import net.danygames2014.unitweaks.util.ModOptions;
import net.minecraft.class_471;
import net.minecraft.class_50;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_471.class)
public class WorldRendererMixin {
    @WrapOperation(method = "renderClouds", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/dimension/Dimension;getCloudHeight()F"))
    public float changeCloudHeight(class_50 instance, Operation<Float> original) {
        if (UniTweaks.USER_INTERFACE_CONFIG.videoSettingsConfig.cloudHeightSlider) {
            return ModOptions.getCloudHeight();
        }
        return original.call(instance);
    }

    @WrapOperation(method = "renderFancyClouds", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/dimension/Dimension;getCloudHeight()F"))
    public float ChangeFancyCloudHeight(class_50 instance, Operation<Float> original) {
        if (UniTweaks.USER_INTERFACE_CONFIG.videoSettingsConfig.cloudHeightSlider) {
            return ModOptions.getCloudHeight();
        }
        return original.call(instance);
    }
}
