package net.danygames2014.unitweaks.mixin.tweaks.moresounds;

import net.danygames2014.unitweaks.UniTweaks;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_31;
import net.minecraft.class_500;
import net.minecraft.class_54;
import net.minecraft.class_57;
import net.minecraft.client.Minecraft;
import org.objectweb.asm.Opcodes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Random;

@Mixin(class_31.class)
public abstract class ItemStackMixin {
    @Shadow
    public abstract class_124 getItem();

    @Unique
    private static final Random random = new Random();

    @Inject(method = "damage", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/player/PlayerEntity;increaseStat(Lnet/minecraft/stat/Stat;I)V", shift = At.Shift.AFTER))
    public void playSoundOnToolBreak(int amount, class_57 entity, CallbackInfo ci) {
        if (UniTweaks.FEATURES_CONFIG.moreSounds) {
            class_54 player = (class_54) entity;

            player.field_1596.method_191(player, "unitweaks:random.break", 1.0f, (random.nextFloat() - random.nextFloat()) * 0.2F + 1.0F);
        }
    }

    @SuppressWarnings("deprecation")
    @Environment(EnvType.CLIENT)
    @Inject(method = "damage", at = @At(value = "FIELD", opcode = Opcodes.PUTFIELD, target = "Lnet/minecraft/item/ItemStack;count:I", ordinal = 0, shift = At.Shift.BEFORE))
    public void playSoundOnArmorBreak(int amount, class_57 entity, CallbackInfo ci) {
        if (UniTweaks.FEATURES_CONFIG.moreSounds) {
            if (this.getItem() instanceof class_500) {
                if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                    Minecraft minecraft = (Minecraft) FabricLoader.getInstance().getGameInstance();
                    class_54 player = minecraft.field_2806;
                    player.field_1596.method_191(player, "unitweaks:random.break", 1.0f, (random.nextFloat() - random.nextFloat()) * 0.2F + 1.0F);
                }
            }
        }
    }
}
