package net.danygames2014.unitweaks.mixin.tweaks.pickblockfrominventory;

import net.danygames2014.unitweaks.UniTweaks;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_136;
import net.minecraft.class_31;
import net.minecraft.class_363;
import net.minecraft.class_54;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_136.class)
public class PlayerInventoryMixin {

    @Unique
    private static final int[] slotIndexToClickSlotIndex = new int[]{
            36, 37, 38, 39, 40, 41, 42, 43, 44, // Hotbar / 4th row
            27, 28, 29, 30, 31, 32, 33, 34, 35, // 3rd row
            18, 19, 20, 21, 22, 23, 24, 25, 26, // 2nd row
            9, 10, 11, 12, 13, 14, 15, 16, 17 // 1st row
    };

    @Unique
    private static short actionTypeCounter = 0;

    @Shadow
    public class_54 player;

    @Shadow
    public class_31[] main;

    @Shadow
    public int selectedSlot;

    @Environment(EnvType.CLIENT)
    @Inject(method = "setHeldItem", at = @At("HEAD"), cancellable = true)
    public void setSelectedItem(int id, boolean bl, CallbackInfo ci) {
        int itemMeta = id & 0xF;
        int itemId = id >>> 4;
        
        if (UniTweaks.GAMEPLAY_CONFIG.pickBlockFromInventory) {
            int slotWithItemIndex = -1;
            int hotbarSlotIndex;

            // Find the item with meta matching
            for (int i = 0; i < main.length; i++) {
                if (main[i] != null && main[i].field_753 == itemId && main[i].method_722() == itemMeta) {
                    slotWithItemIndex = i;
                    break;
                }
            }
            
            // If no item was found with meta matching, try without it
            if (slotWithItemIndex == -1) {
                for (int i = 0; i < main.length; i++) {
                    if (main[i] != null && main[i].field_753 == itemId) {
                        slotWithItemIndex = i;
                        break;
                    }
                }
            }

            // Item not found, no point in continuing
            if (slotWithItemIndex == -1) {
                ci.cancel();
                return;
            }

            if (slotWithItemIndex < 9) { // The item is in hotbar, select the slot
                selectedSlot = slotWithItemIndex;
            } else { // Item is not in in hotbar
                // Find a hotbar slot to put the item into
                if (player.field_519.method_675() == null) {
                    // Selected hotbar slot is empty, put it there
                    hotbarSlotIndex = this.selectedSlot;
                } else {
                    // Selected htobar slot isn't empty, try to find a free one
                    hotbarSlotIndex = getEmptyHotbarSlot();
                }

                // Handle putting the item in hand
                if (!player.field_1596.field_180) { // SINGLEPLAYER
                    if (hotbarSlotIndex != -1) { // hotbarSlot isn't -1, therefore a free hotbar slot has been found
                        selectedSlot = hotbarSlotIndex;
                        main[hotbarSlotIndex] = main[slotWithItemIndex];
                        main[slotWithItemIndex] = null;
                    } else { // hotbarSlot = -1 means that no hotbar slot is free
                        class_31 tempItem = player.method_502();
                        main[selectedSlot] = main[slotWithItemIndex];
                        main[slotWithItemIndex] = tempItem;
                    }
                } else { // MULTIPLAYER
                    if (hotbarSlotIndex != -1) { // free slot found
                        selectedSlot = hotbarSlotIndex;

                        // WELL, there was an attempt, just realized no scren is open an di kinda want ot go to sleep
//                        sendClickPacket(slotWithItemIndex, main[slotWithItemIndex]);
//                        sendClickPacket(hotbarSlotIndex, main[slotWithItemIndex]);
                    } else { // no free slot

                    }
                }
            }
        }
    }

    @Unique
    public void sendClickPacket(int slot, class_31 stack) {
        class_363 packet = new class_363(0, slotIndexToClickSlotIndex[slot], 0, false, stack, actionTypeCounter);
        actionTypeCounter++;
    }

    @Unique
    public int getEmptyHotbarSlot() {
        // 0-8 in main inventory is the hotbar
        for (int i = 0; i < 9; i++) {
            if (main[i] == null) {
                return i;
            }
        }
        return -1;
    }
}
