package net.danygames2014.unitweaks.mixin.bugfixes.fenceboundingboxfix;

import net.danygames2014.unitweaks.UniTweaks;
import net.minecraft.class_14;
import net.minecraft.class_15;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_229;
import net.minecraft.class_25;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_229.class)
public class FenceBlockMixin extends class_17 {

    @Unique
    private static class_18 world;

    public FenceBlockMixin(int id, class_15 material) {
        super(id, material);
    }

    @Unique
    private class_25 generateBox(class_18 world, int x, int y, int z) {
        boolean connectPosX;
        boolean connectNegX;
        boolean connectPosZ;
        boolean connectNegZ;
        int fenceId = class_17.field_1902.field_1915;
        int glowstoneId = class_17.field_1906.field_1915;

        if (UniTweaks.TWEAKS_CONFIG.fencesConnectBlocks) {
            connectPosX = (world.method_1780(x + 1, y, z) || world.method_1776(x + 1, y, z) == fenceId) && world.method_1776(x + 1, y, z) != glowstoneId;
            connectNegX = (world.method_1780(x - 1, y, z) || world.method_1776(x - 1, y, z) == fenceId) && world.method_1776(x - 1, y, z) != glowstoneId;
            connectNegZ = (world.method_1780(x, y, z - 1) || world.method_1776(x, y, z - 1) == fenceId) && world.method_1776(x, y, z - 1) != glowstoneId;
            connectPosZ = (world.method_1780(x, y, z + 1) || world.method_1776(x, y, z + 1) == fenceId) && world.method_1776(x, y, z + 1) != glowstoneId;
        } else {
            connectPosX = world.method_1776(x + 1, y, z) == fenceId;
            connectNegX = world.method_1776(x - 1, y, z) == fenceId;
            connectPosZ = world.method_1776(x, y, z + 1) == fenceId;
            connectNegZ = world.method_1776(x, y, z - 1) == fenceId;
        }

        return class_25.method_87(connectNegX ? 0 : 0.375F, 0F, connectNegZ ? 0F : 0.375F, connectPosX ? 1F : 0.625F, 1F, connectPosZ ? 1.F : 0.625F);
    }

    @Unique
    private class_25 generateBox(class_18 world, int x, int y, int z, boolean collider) {
        class_25 box = generateBox(world, x, y, z);

        box.field_129 += x;
        box.field_130 += y;
        box.field_131 += z;
        box.field_132 += x;
        box.field_133 += y;
        box.field_134 += z;

        if (collider) {
            if (UniTweaks.GAMEPLAY_CONFIG.fenceJumping) {
                box.field_133 += 0.26F;
            } else {
                box.field_133 += 0.5F;
            }
        }

        return box;
    }

    @Inject(method = "getCollisionShape", at = @At("RETURN"), cancellable = true)
    public void getCollisionShape(class_18 world, int x, int y, int z, CallbackInfoReturnable<class_25> cir) {
        if (UniTweaks.BUGFIXES_CONFIG.fenceBoundingBoxFix) {
            cir.setReturnValue(generateBox(world, x, y, z, true));
        }
    }

    @Override
    public class_25 method_1622(class_18 world, int x, int y, int z) {
        if (UniTweaks.BUGFIXES_CONFIG.fenceBoundingBoxFix) {
            FenceBlockMixin.world = world;
            return generateBox(world, x, y, z, false);
        } else {
            return super.method_1622(world, x, y, z);
        }
    }

    @Override
    public void method_1616(class_14 blockView, int x, int y, int z) {
        if (UniTweaks.BUGFIXES_CONFIG.fenceBoundingBoxFix) {
            if (world == null)
                return;
            class_25 box = generateBox(world, x, y, z);
            method_1578((float) box.field_129, (float) box.field_130, (float) box.field_131, (float) box.field_132, (float) box.field_133, (float) box.field_134);
        } else {
            super.method_1616(blockView, x, y, z);
        }
    }
}
