package net.danygames2014.unitweaks.mixin.tweaks.fov;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.danygames2014.unitweaks.tweaks.morekeybinds.KeyBindingListener;
import net.danygames2014.unitweaks.util.CompatHelper;
import net.danygames2014.unitweaks.util.ModOptions;
import net.danygames2014.unitweaks.util.Util;
import net.minecraft.class_127;
import net.minecraft.class_15;
import net.minecraft.class_555;
import net.minecraft.client.Minecraft;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;
import org.objectweb.asm.Opcodes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.function.BiFunction;

@Mixin(class_555.class)
public class GameRendererMixin {
    @Shadow
    private Minecraft client;

    @Shadow
    private float viewDistance;

    @Unique
    public float fov = 70F;

    @Unique
    float fovZoom = 0F;

    @Unique
    boolean zoomedIn = false;

    @Unique
    public float getFovMultiplier(float partialTicks, boolean isHand) {
        class_127 cameraEntity = this.client.field_2807;
        fov = ModOptions.getFovInDegrees();

        if (isHand) {
            fov = 70F;
        }

        if (cameraEntity.method_1328(class_15.field_985)) {
            fov *= 60.0F / 70.0F;
        }

        if (Keyboard.isKeyDown(KeyBindingListener.zoom.field_2381) && client.field_2816 == null) {
            if (!zoomedIn) {
                ModOptions.zoomFovOffset = 0;
                fovZoom = 0F;
                zoomedIn = true;
            }

            if (!isHand) {
                fov /= 4F;

                fovZoom += ModOptions.zoomFovOffset * 5;
                ModOptions.zoomFovOffset = 0;

                fovZoom = Util.clamp(fovZoom, 5F - fov, 130F - fov);
            } else {
                fov -= (ModOptions.getFovInDegrees() - 50F);
            }

            fov += fovZoom;

//            System.out.println("isHand = " + isHand + " | fov = " + fov + " | fovZoom = " + fovZoom + " | 5f-fov = " + (5f - fov) + " | 130f-fov = " + (130f - fov));

        } else {
            zoomedIn = false;
        }

        if (cameraEntity.field_1036 <= 0) {
            float deathTimeFov = (float) cameraEntity.field_1041 + partialTicks;
            fov /= (1.0F - 500F / (deathTimeFov + 500F)) * 2.0F + 1.0F;
        }

        // Mod Compat
        for (BiFunction<Float, Float, Float> modFovModifier : CompatHelper.fovMethods) {
            fov = modFovModifier.apply(fov, partialTicks);
        }

        return fov;
    }

    @ModifyExpressionValue(method = "onFrameUpdate", at = @At(value = "FIELD", opcode = Opcodes.GETFIELD, target = "Lnet/minecraft/client/option/GameOptions;cinematicMode:Z"))
    public boolean smoothCameraWhenZooming(boolean original) {
        return original || Keyboard.isKeyDown(KeyBindingListener.zoom.field_2381);
    }

    @Unique
    public float getFovMultiplier(float f) {
        return getFovMultiplier(f, false);
    }

    @WrapOperation(method = "renderWorld", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/render/GameRenderer;getFov(F)F"))
    public float redirectToCustomFov(class_555 instance, float value, Operation<Float> original) {
        return getFovMultiplier(value);
    }

    @Inject(method = "renderFirstPersonHand", at = @At(value = "HEAD"))
    public void adjustHandFov(float f, int i, CallbackInfo ci) {
        GL11.glMatrixMode(GL11.GL_PROJECTION);
        GL11.glLoadIdentity();
        GLU.gluPerspective(getFovMultiplier(f, true), (float) client.field_2802 / (float) client.field_2803, 0.05F, viewDistance * 2.0F);
        GL11.glMatrixMode(GL11.GL_MODELVIEW);
    }
}
