package net.danygames2014.unitweaks.mixin.tweaks.modernflintandsteel;

import net.danygames2014.unitweaks.UniTweaks;
import net.minecraft.class_18;
import net.minecraft.class_31;
import net.minecraft.class_539;
import net.minecraft.class_54;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_539.class)
public class FlintAndSteelItemMixin {
    @Inject(method = "useOnBlock", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/World;setBlock(IIII)Z", shift = At.Shift.AFTER), cancellable = true)
    public void damageOnSuccesfulIgnite(class_31 stack, class_54 user, class_18 world, int x, int y, int z, int side, CallbackInfoReturnable<Boolean> cir) {
        if (UniTweaks.TWEAKS_CONFIG.modernFlintAndSteel) {
            stack.method_697(1, user);
            cir.setReturnValue(true);
        }
    }

    @ModifyConstant(method = "useOnBlock", constant = @Constant(intValue = 1, ordinal = 1))
    public int disableVanillaDamage(int constant) {
        if (UniTweaks.TWEAKS_CONFIG.modernFlintAndSteel) {
            return 0;
        }
        return constant;
    }
}
