/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.unitweaks.tweaks.rawinput;

import java.awt.Component;
import java.util.ArrayList;
import net.danygames2014.unitweaks.UniTweaks;
import net.danygames2014.unitweaks.tweaks.rawinput.RawMouseHelper;
import net.danygames2014.unitweaks.util.Util;
import net.java.games.input.AbstractController;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.java.games.input.Mouse;
import net.minecraft.class_40;
import net.minecraft.class_596;
import net.minecraft.client.Minecraft;
import org.apache.logging.log4j.Logger;

public class RawInputHandler {
    private static final Logger logger = UniTweaks.LOGGER;
    public static Controller[] controllers;
    public static ArrayList<Mouse> mice;
    public static int dx;
    public static int dy;
    private static int worldJoinTimer;
    private static boolean shouldGetMouse;
    public static boolean rawInputEnabled;
    public static Thread inputThread;
    public static boolean runInputThread;

    public static void init() {
        RawInputHandler.startInputThread();
    }

    public static void startInputThread() {
        if (inputThread != null && inputThread.isAlive()) {
            return;
        }
        inputThread = new Thread(() -> {
            while (runInputThread) {
                if (!mice.isEmpty() && Minecraft.field_2791.field_2816 == null) {
                    mice.forEach(mouse -> {
                        mouse.poll();
                        dx += (int)mouse.getX().getPollData();
                        dy += (int)mouse.getY().getPollData();
                    });
                } else if (!mice.isEmpty()) {
                    mice.forEach(AbstractController::poll);
                }
                try {
                    if (!rawInputEnabled) {
                        Thread.sleep(1000L);
                        if (Minecraft.field_2791.field_2767 instanceof RawMouseHelper) {
                            rawInputEnabled = true;
                        }
                    }
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    UniTweaks.LOGGER.error((Object)e.getStackTrace());
                }
            }
        });
        runInputThread = true;
        inputThread.setName("inputThread");
        inputThread.start();
    }

    public static void getMouse(String reason) {
        logger.debug(String.format("getMouse called. Reason: %s. Should get mouse: %s", reason, shouldGetMouse));
        ControllerEnvironment controllerEnvironment = ControllerEnvironment.getDefaultEnvironment();
        controllers = controllerEnvironment.getControllers();
        mice = new ArrayList();
        for (Controller controller : controllers) {
            logger.info("Found Controller " + controller.getName() + " of type " + String.valueOf(controller.getType()));
            if (!(controller instanceof Mouse)) continue;
            Mouse mouseController = (Mouse)controller;
            mice.add(mouseController);
        }
        logger.info("Found " + mice.size() + " mouse controllers");
        if (mice.isEmpty()) {
            Util.notify("No mouse controllers found, switching back to Vanilla Mouse Helper", true);
            RawInputHandler.disableRawInput(false, true);
        }
    }

    public static void toggleRawInput() {
        class_40 player = Minecraft.field_2791.field_2806;
        float saveYaw = player.field_1606;
        float savePitch = player.field_1607;
        if (Minecraft.field_2791.field_2767 instanceof RawMouseHelper) {
            RawInputHandler.disableRawInput(true, true);
        } else {
            RawInputHandler.enableRawInput(true, true);
        }
        player.field_1606 = saveYaw;
        player.field_1607 = savePitch;
    }

    public static void enableRawInput(boolean lock, boolean notifyInChat) {
        Util.notify("Raw Input Toggled ON", notifyInChat);
        Minecraft.field_2791.field_2767 = new RawMouseHelper(Minecraft.field_2791.field_2811);
        if (lock) {
            Minecraft.field_2791.field_2767.method_1970();
        }
        rawInputEnabled = true;
        RawInputHandler.startInputThread();
        RawInputHandler.getMouse("Enabled Raw Input");
    }

    public static void disableRawInput(boolean lock, boolean notifyInChat) {
        Minecraft.field_2791.field_2767 = new class_596((Component)Minecraft.field_2791.field_2811);
        if (lock) {
            Minecraft.field_2791.field_2767.method_1970();
        }
        rawInputEnabled = false;
        runInputThread = false;
        Util.notify("Raw Input Toggled OFF", notifyInChat);
    }

    public static void tick() {
        if (worldJoinTimer >= 0) {
            --worldJoinTimer;
        }
        if (shouldGetMouse) {
            RawInputHandler.getMouse("Post Join/Leave Timer");
            shouldGetMouse = false;
        }
    }

    public static void onJoinWorld() {
        worldJoinTimer = 3;
        shouldGetMouse = true;
    }

    public static void onLeaveWorld() {
        shouldGetMouse = false;
    }

    static {
        mice = new ArrayList();
        dx = 0;
        dy = 0;
        shouldGetMouse = false;
        rawInputEnabled = false;
        runInputThread = false;
    }
}

