package net.danygames2014.unitweaks.mixin.options;

import net.danygames2014.unitweaks.UniTweaks;
import net.danygames2014.unitweaks.util.ModOptions;
import net.danygames2014.unitweaks.util.Util;
import net.minecraft.class_271;
import net.minecraft.class_300;
import net.minecraft.class_322;
import net.minecraft.class_564;
import net.minecraft.client.Minecraft;
import org.lwjgl.input.Mouse;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

import java.io.BufferedReader;
import java.io.PrintWriter;

@Mixin(class_322.class)
public abstract class GameOptionsMixin {
    @Shadow
    protected abstract float parseFloat(String string);

    @Shadow
    protected Minecraft minecraft;

    @Inject(method = "setFloat", at = @At(value = "HEAD"))
    public void setFloat(class_271 option, float value, CallbackInfo ci) {
        if (option == ModOptions.fovOption) {
            ModOptions.fov = value;
        }

        if (option == ModOptions.fogDensityOption && UniTweaks.USER_INTERFACE_CONFIG.videoSettingsConfig.fogDensitySlider) {
            ModOptions.fogDensity = value;
        }

        if (option == ModOptions.cloudHeightOption && UniTweaks.USER_INTERFACE_CONFIG.videoSettingsConfig.cloudHeightSlider) {
            ModOptions.cloudHeight = value;
        }

        if (option == ModOptions.fpsLimitOption && UniTweaks.USER_INTERFACE_CONFIG.videoSettingsConfig.fpsLimitSlider) {
            ModOptions.fpsLimit = value;
        }

        if (option == ModOptions.renderDistanceOption && UniTweaks.USER_INTERFACE_CONFIG.videoSettingsConfig.renderDistanceSlider) {
            ModOptions.renderDistance = value;
        }

        if (option == ModOptions.brightnessOption && UniTweaks.USER_INTERFACE_CONFIG.videoSettingsConfig.brightnessSlider) {
            if (!Mouse.isButtonDown(0) && ModOptions.brightness != value) {
                ModOptions.brightness = value;
                ModOptions.updateWorldLightTable(minecraft);
            }
        }

        if (option == ModOptions.guiScaleOption && UniTweaks.USER_INTERFACE_CONFIG.videoSettingsConfig.guiScaleSlider) {
            ModOptions.guiScale = value;

            if (!Mouse.isButtonDown(0)) {
                ModOptions.realGuiScale = value;

                class_564 screenScaler = new class_564(this.minecraft.field_2824, this.minecraft.field_2802, this.minecraft.field_2803);
                int scaledWidth = screenScaler.method_1857();
                int scaledHeight = screenScaler.method_1858();
                this.minecraft.field_2816.method_125(this.minecraft, scaledWidth, scaledHeight);
            }
        }
    }

    @Inject(method = "setInt", at = @At(value = "HEAD"))
    public void setBoolean(class_271 option, int value, CallbackInfo ci) {
        if (option == ModOptions.cloudsOption && UniTweaks.USER_INTERFACE_CONFIG.videoSettingsConfig.cloudsToggle) {
            ModOptions.clouds = !ModOptions.clouds;
        }
    }


    @Inject(method = "getFloat", at = @At(value = "HEAD"), cancellable = true)
    public void getFloat(class_271 option, CallbackInfoReturnable<Float> cir) {
        if (option == ModOptions.fovOption) {
            cir.setReturnValue(ModOptions.fov);
        }

        if (option == ModOptions.fogDensityOption && UniTweaks.USER_INTERFACE_CONFIG.videoSettingsConfig.fogDensitySlider) {
            cir.setReturnValue(ModOptions.fogDensity);
        }

        if (option == ModOptions.cloudHeightOption && UniTweaks.USER_INTERFACE_CONFIG.videoSettingsConfig.cloudHeightSlider) {
            cir.setReturnValue(ModOptions.cloudHeight);
        }

        if (option == ModOptions.fpsLimitOption && UniTweaks.USER_INTERFACE_CONFIG.videoSettingsConfig.fpsLimitSlider) {
            cir.setReturnValue(ModOptions.fpsLimit);
        }

        if (option == ModOptions.renderDistanceOption && UniTweaks.USER_INTERFACE_CONFIG.videoSettingsConfig.renderDistanceSlider) {
            cir.setReturnValue(ModOptions.renderDistance);
        }

        if (option == ModOptions.brightnessOption && UniTweaks.USER_INTERFACE_CONFIG.videoSettingsConfig.brightnessSlider) {
            cir.setReturnValue(ModOptions.brightness);
        }

        if (option == ModOptions.guiScaleOption && UniTweaks.USER_INTERFACE_CONFIG.videoSettingsConfig.guiScaleSlider) {
            cir.setReturnValue(ModOptions.guiScale);
        }
    }

    @Inject(method = "getBoolean", at = @At(value = "HEAD"), cancellable = true)
    public void getBoolean(class_271 option, CallbackInfoReturnable<Boolean> cir) {
        if (option == ModOptions.cloudsOption && UniTweaks.USER_INTERFACE_CONFIG.videoSettingsConfig.cloudsToggle) {
            cir.setReturnValue(ModOptions.clouds);
        }
    }


    @Inject(method = "getString", at = @At(value = "HEAD"), cancellable = true)
    public void getTranslatedValue(class_271 option, CallbackInfoReturnable<String> cir) {
        class_300 translations = class_300.method_992();

        if (option == ModOptions.fovOption) {
            float value = ModOptions.fov;
            if (value == 0.0f) {
                cir.setReturnValue(translations.method_993("options.unitweaks.fov") + ": " + translations.method_993("options.unitweaks.fov.normal"));
            } else if (value == 1.0f) {
                cir.setReturnValue(translations.method_993("options.unitweaks.fov") + ": " + translations.method_993("options.unitweaks.fov.max"));
            } else {
                cir.setReturnValue(translations.method_993("options.unitweaks.fov") + ": " + ModOptions.getFovInDegrees());
            }
        }

        if (option == ModOptions.fogDensityOption) {
            float value = ModOptions.getFogDisplayValue();
            if (value == 0.0F) {
                cir.setReturnValue(translations.method_993("options.unitweaks.fog") + ": " + translations.method_993("options.unitweaks.fog.off"));
            } else if (value == 1.0F) {
                cir.setReturnValue(translations.method_993("options.unitweaks.fog") + ": " + translations.method_993("options.unitweaks.fog.max"));
            } else if (value == 0.5F) {
                cir.setReturnValue(translations.method_993("options.unitweaks.fog") + ": " + translations.method_993("options.unitweaks.fog.normal"));
            } else {
                cir.setReturnValue(translations.method_993("options.unitweaks.fog") + ": " + ModOptions.getFogDisplayValue() * 2F + translations.method_993("options.unitweaks.multiplier_symbol"));
            }
        }

        if (option == ModOptions.fpsLimitOption) {
            float value = ModOptions.getFpsLimitValue();
            if (value >= 300) {
                cir.setReturnValue(translations.method_993("options.unitweaks.fps_limit") + ": " + translations.method_993("options.unitweaks.fps_limit.max"));
            } else {
                cir.setReturnValue(translations.method_993("options.unitweaks.fps_limit") + ": " + value);
            }
        }

        if (option == ModOptions.cloudHeightOption) {
            String optionName = translations.method_993("options.unitweaks.cloud_height") + ": " + ModOptions.getCloudHeight();
            cir.setReturnValue(optionName);
        }

        if (option == ModOptions.cloudsOption) {
            String optionName = translations.method_993("options.unitweaks.clouds") + ": " + (ModOptions.clouds ? translations.method_993("options.on") : translations.method_993("options.off"));
            cir.setReturnValue(optionName);
        }

        if (option == ModOptions.renderDistanceOption) {
            String chunkValue;
            switch (ModOptions.getRenderDistanceChunks()) {
                case 2 -> chunkValue = translations.method_993("options.unitweaks.render_distance.tiny");
                case 4 -> chunkValue = translations.method_993("options.unitweaks.render_distance.short");
                case 8 -> chunkValue = translations.method_993("options.unitweaks.render_distance.normal");
                case 12 -> chunkValue = translations.method_993("options.unitweaks.render_distance.far");
                default ->
                        chunkValue = ModOptions.getRenderDistanceChunks() + " " + translations.method_993("options.unitweaks.render_distance.chunks");
            }
            String optionName = translations.method_993("options.unitweaks.render_distance") + ": " + chunkValue;
            cir.setReturnValue(optionName);
        }

        if (option == ModOptions.brightnessOption) {
            String brightnessValue;
            if (ModOptions.brightness == 0F) {
                brightnessValue = translations.method_993("options.unitweaks.brightness.min");
            } else if (ModOptions.brightness == 1F) {
                brightnessValue = translations.method_993("options.unitweaks.brightness.max");
            } else {
                brightnessValue = Util.ceil(ModOptions.brightness * 100F) + "%";
            }
            String optionName = translations.method_993("options.unitweaks.brightness") + ": " + brightnessValue;
            cir.setReturnValue(optionName);
        }

        if (option == ModOptions.guiScaleOption) {
            String guiScaleValue = ModOptions.getGuiScaleDisplayValue() == 0 ? translations.method_993("options.unitweaks.gui_scale.auto") : ModOptions.getGuiScaleDisplayValue() + translations.method_993("options.unitweaks.multiplier_symbol");
            String optionName = translations.method_993("options.unitweaks.gui_scale") + ": " + guiScaleValue;
            cir.setReturnValue(optionName);
        }
    }

    @Inject(method = "load", at = @At(value = "INVOKE", target = "Ljava/lang/String;split(Ljava/lang/String;)[Ljava/lang/String;"), locals = LocalCapture.CAPTURE_FAILHARD)
    private void load(CallbackInfo ci, BufferedReader bufferedReader, String string) {
        String[] stringArray = string.split(":");

        if (stringArray[0].equals("fov")) {
            ModOptions.fov = this.parseFloat(stringArray[1]);
        }

        if (stringArray[0].equals("fog_density") && UniTweaks.USER_INTERFACE_CONFIG.videoSettingsConfig.fogDensitySlider) {
            ModOptions.fogDensity = this.parseFloat(stringArray[1]);
        }

        if (stringArray[0].equals("clouds") && UniTweaks.USER_INTERFACE_CONFIG.videoSettingsConfig.cloudsToggle) {
            ModOptions.clouds = stringArray[1].equals("true");
        }

        if (stringArray[0].equals("cloud_height") && UniTweaks.USER_INTERFACE_CONFIG.videoSettingsConfig.cloudHeightSlider) {
            ModOptions.cloudHeight = this.parseFloat(stringArray[1]);
        }

        if (stringArray[0].equals("fps_limit") && UniTweaks.USER_INTERFACE_CONFIG.videoSettingsConfig.fpsLimitSlider) {
            ModOptions.fpsLimit = this.parseFloat(stringArray[1]);
        }

        if (stringArray[0].equals("render_distance") && UniTweaks.USER_INTERFACE_CONFIG.videoSettingsConfig.renderDistanceSlider) {
            ModOptions.renderDistance = this.parseFloat(stringArray[1]);
        }

        if (stringArray[0].equals("brightness") && UniTweaks.USER_INTERFACE_CONFIG.videoSettingsConfig.brightnessSlider) {
            ModOptions.brightness = this.parseFloat(stringArray[1]);
            ModOptions.updateWorldLightTable(minecraft);
        }

        if (stringArray[0].equals("gui_scale") && UniTweaks.USER_INTERFACE_CONFIG.videoSettingsConfig.guiScaleSlider) {
            ModOptions.guiScale = this.parseFloat(stringArray[1]);
            ModOptions.realGuiScale = ModOptions.guiScale;
        }
    }

    @Inject(method = "save", at = @At(value = "INVOKE", target = "Ljava/io/PrintWriter;close()V"), locals = LocalCapture.CAPTURE_FAILHARD)
    private void saveOptions(CallbackInfo ci, PrintWriter printWriter) {
        printWriter.println("fov:" + ModOptions.fov);

        if (UniTweaks.USER_INTERFACE_CONFIG.videoSettingsConfig.fogDensitySlider) {
            printWriter.println("fog_density:" + ModOptions.fogDensity);
        }

        if (UniTweaks.USER_INTERFACE_CONFIG.videoSettingsConfig.cloudsToggle) {
            printWriter.println("clouds:" + ModOptions.clouds);
        }

        if (UniTweaks.USER_INTERFACE_CONFIG.videoSettingsConfig.cloudHeightSlider) {
            printWriter.println("cloud_height:" + ModOptions.cloudHeight);
        }

        if (UniTweaks.USER_INTERFACE_CONFIG.videoSettingsConfig.fpsLimitSlider) {
            printWriter.println("fps_limit: " + ModOptions.fpsLimit);
        }

        if (UniTweaks.USER_INTERFACE_CONFIG.videoSettingsConfig.renderDistanceSlider) {
            printWriter.println("render_distance: " + ModOptions.renderDistance);
        }

        if (UniTweaks.USER_INTERFACE_CONFIG.videoSettingsConfig.brightnessSlider) {
            printWriter.println("brightness:" + ModOptions.brightness);
        }

        if (UniTweaks.USER_INTERFACE_CONFIG.videoSettingsConfig.guiScaleSlider) {
            printWriter.println("gui_scale:" + ModOptions.guiScale);
        }
    }
}
