package net.danygames2014.unitweaks.mixin.tweaks.recipes;

import net.danygames2014.unitweaks.UniTweaks;
import net.danygames2014.unitweaks.tweaks.recipes.FuelLookup;
import net.minecraft.class_138;
import net.minecraft.class_31;
import net.minecraft.class_55;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_138.class)
public class FurnaceBlockEntityMixin extends class_55 {
    @Inject(method = "getFuelTime", at = @At(value = "HEAD"), cancellable = true)
    public void injectFuelValues(class_31 stack, CallbackInfoReturnable<Integer> cir){
        if(UniTweaks.RECIPES_CONFIG.furnaceFuels) {
            if (stack != null) {
                FuelLookup.FuelLookupEntry entry = FuelLookup.lookup.get(stack.method_694());

                if(entry != null){
                    if(entry.meta() == -1 || entry.meta() == stack.method_722()) {
                        cir.setReturnValue(entry.fuelTime());
                    }
                }
            }
        }
    }
}
