package net.danygames2014.unitweaks.tweaks.rawinput;

import net.danygames2014.unitweaks.UniTweaks;
import net.danygames2014.unitweaks.util.Util;
import net.java.games.input.AbstractController;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.java.games.input.Mouse;
import net.minecraft.class_54;
import net.minecraft.client.Minecraft;
import org.apache.logging.log4j.Logger;

import java.util.ArrayList;

@SuppressWarnings({"StringConcatenationArgumentToLogCall", "BusyWait"})
public class RawInputHandler {
    private static final Logger logger = UniTweaks.LOGGER;

    public static Controller[] controllers;
    public static ArrayList<Mouse> mice = new ArrayList<>();

    public static int dx = 0;
    public static int dy = 0;

    private static int worldJoinTimer;

    private static boolean shouldGetMouse = false;
    public static boolean rawInputEnabled = false;
    
    public static Thread inputThread;
    public static boolean runInputThread = false;

    public static void init() {
        startInputThread();
    }

    public static void startInputThread() {
        if (inputThread != null && inputThread.isAlive()) {
            return;
        }
        
        inputThread = new Thread(() -> {
            while (runInputThread) {
                if (!mice.isEmpty() && Minecraft.field_2791.field_2816 == null) {
                    mice.forEach(mouse -> {
                        mouse.poll();
                        dx += (int) mouse.getX().getPollData();
                        dy += (int) mouse.getY().getPollData();
                    });
                } else if (!mice.isEmpty()) {
                    mice.forEach(AbstractController::poll);
                }

                try {
                    // Don't run that often if raw input aint enabled anyway
                    if (!rawInputEnabled) {
                        Thread.sleep(1000);

                        // If for some reason the value is wrong, correct it
                        if (Minecraft.field_2791.field_2767 instanceof RawMouseHelper) {
                            rawInputEnabled = true;
                        }
                    }

                    Thread.sleep(1);
                } catch (InterruptedException e) {
                    UniTweaks.LOGGER.error(e.getStackTrace());
                }
            }
        });

        runInputThread = true;
        inputThread.setName("inputThread");
        inputThread.start();
    }

    public static void getMouse(String reason) {
        // Log a debug message
        logger.debug(String.format("getMouse called. Reason: %s. Should get mouse: %s", reason, shouldGetMouse));

        // Setup the controller environment
        ControllerEnvironment controllerEnvironment = ControllerEnvironment.getDefaultEnvironment();
        controllers = controllerEnvironment.getControllers();

        // Reset the mice arraylist
        mice = new ArrayList<>();

        // Go thru controllers and find mice
        for (Controller controller : controllers) {
            logger.info("Found Controller " + controller.getName() + " of type " + controller.getType());
            if (controller instanceof Mouse mouseController) {
                mice.add(mouseController);
                //logger.info("Adding Controller " + controller.getName() + " of type " + controller.getType());
            }
        }

        // Announce the number of found controllers, on Linux this will probably be dissapoitning
        logger.info("Found " + mice.size() + " mouse controllers");

        // If none are found, fall back to Vanilla Mouse Helper
        if (mice.isEmpty()) {
            Util.notify("No mouse controllers found, switching back to Vanilla Mouse Helper", true);
            disableRawInput(false, true);
        }
    }

    public static void toggleRawInput() {
        class_54 player = Minecraft.field_2791.field_2806;
        float saveYaw = player.field_1606;
        float savePitch = player.field_1607;

        if (Minecraft.field_2791.field_2767 instanceof RawMouseHelper) {
            disableRawInput(true, true);
        } else {
            enableRawInput(true, true);
        }

        player.field_1606 = saveYaw;
        player.field_1607 = savePitch;
    }

    public static void enableRawInput(boolean lock, boolean notifyInChat) {
        Util.notify("Raw Input Toggled ON", notifyInChat);
        Minecraft.field_2791.field_2767 = new RawMouseHelper(Minecraft.field_2791.field_2811);
        if (lock) {
            Minecraft.field_2791.field_2767.method_1970();
        }
        rawInputEnabled = true;
        startInputThread();
        getMouse("Enabled Raw Input");
    }

    public static void disableRawInput(boolean lock, boolean notifyInChat) {
        Minecraft.field_2791.field_2767 = new net.minecraft.class_596(Minecraft.field_2791.field_2811);
        if (lock) {
            Minecraft.field_2791.field_2767.method_1970();
        }
        rawInputEnabled = false;
        runInputThread = false;
        Util.notify("Raw Input Toggled OFF", notifyInChat);
    }

    public static void tick() {
        if (worldJoinTimer >= 0) {
            worldJoinTimer--;
        }
        if (shouldGetMouse) {
            getMouse("Post Join/Leave Timer");
            shouldGetMouse = false;
        }
    }

    public static void onJoinWorld() {
//        UniTweaks.logger.info(String.format("Player Joined World. Getting Mouse"));
        worldJoinTimer = 3;
        shouldGetMouse = true;

    }

    public static void onLeaveWorld() {
        shouldGetMouse = false;
    }
}


