package net.danygames2014.unitweaks.tweaks.recipes;

import net.danygames2014.unitweaks.UniTweaks;
import net.danygames2014.unitweaks.util.CraftingHelper;
import net.mine_diver.unsafeevents.listener.EventListener;
import net.mine_diver.unsafeevents.listener.ListenerPriority;
import net.minecraft.class_124;
import net.minecraft.class_17;
import net.minecraft.class_31;
import net.modificationstation.stationapi.api.event.recipe.RecipeRegisterEvent;

public class RecipeListener {
    @EventListener(priority = ListenerPriority.HIGH)
    public void registerRecipes(RecipeRegisterEvent event) {
        if (UniTweaks.RECIPES_CONFIG.enableRecipes) {
            RecipeRegisterEvent.Vanilla type = RecipeRegisterEvent.Vanilla.fromType(event.recipeId);

            switch (type != null ? type : RecipeRegisterEvent.Vanilla.CRAFTING_SHAPED) {
                case CRAFTING_SHAPED -> {
                    registerShapedRecipes();
                }

                case CRAFTING_SHAPELESS -> {
                    registerShapelessRecipes();
                }

                case SMELTING -> {

                }
            }
        }
    }
    
    public static void registerShapedRecipes() {
        /* Modern Recipes */
        // Slabs Craft 6 per Craft
        if (UniTweaks.RECIPES_CONFIG.modern.sixSlabsPerCraft) {
            CraftingHelper.removeRecipe(class_17.field_1885);
            CraftingHelper.addShapedRecipe(new class_31(class_17.field_1885, 6, 0), "XXX", 'X', new class_31(class_17.field_1945, 1));
            CraftingHelper.addShapedRecipe(new class_31(class_17.field_1885, 6, 1), "XXX", 'X', new class_31(class_17.field_1838, 1));
            CraftingHelper.addShapedRecipe(new class_31(class_17.field_1885, 6, 2), "XXX", 'X', new class_31(class_17.field_1949, 1));
            CraftingHelper.addShapedRecipe(new class_31(class_17.field_1885, 6, 3), "XXX", 'X', new class_31(class_17.field_1948, 1));
        }

        // Buttons crafted with 1 stone
        if (UniTweaks.RECIPES_CONFIG.modern.oneStonePerButton) {
            CraftingHelper.removeRecipe(class_17.field_1866, true);
            CraftingHelper.addShapedRecipe(new class_31(class_17.field_1866, 1), "X", 'X', new class_31(class_17.field_1945, 1));
        }

        // Modern Fence recipe
        if (UniTweaks.RECIPES_CONFIG.modern.modernFenceRecipe) {
            CraftingHelper.removeRecipe(class_17.field_1902, true);
            CraftingHelper.addShapedRecipe(new class_31(class_17.field_1902, 3), "PSP", "PSP", 'P', new class_31(class_17.field_1949, 1), 'S', new class_31(class_124.field_377, 1));
        }

        // Craftable Snow layers (3 Snow Block -> 6 Layers)
        if (UniTweaks.RECIPES_CONFIG.modern.snowLayerRecipe) {
            CraftingHelper.addShapedRecipe(new class_31(class_17.field_1867, 6), "SSS", 'S', new class_31(class_17.field_1869));
        }

        // Ladder craft 3 per craft
        if (UniTweaks.RECIPES_CONFIG.modern.threeLaddersPerCraft) {
            CraftingHelper.removeRecipe(class_17.field_1854, true);
            CraftingHelper.addShapedRecipe(new class_31(class_17.field_1854, 3), "S S", "SSS", "S S", 'S', new class_31(class_124.field_377));
        }

        /* Obtainable Recipes */
        // Craftable Cobwebs
        if (UniTweaks.RECIPES_CONFIG.obtainable.craftableCobwebs) {
            CraftingHelper.addShapedRecipe(new class_31(class_17.field_1844, 1), "S S", " S ", "S S", 'S', new class_31(class_124.field_384, 1));
        }

        // Craftable Coal Ore
        if (UniTweaks.RECIPES_CONFIG.obtainable.craftableCoalOre) {
            CraftingHelper.addShapedRecipe(new class_31(class_17.field_1830, 1), "RRR", "RSR", "RRR", 'R', new class_31(class_124.field_476), 'S', new class_31(class_17.field_1945));
        }

        // Craftable Iron Ore
        if (UniTweaks.RECIPES_CONFIG.obtainable.craftableIronOre) {
            CraftingHelper.addShapedRecipe(new class_31(class_17.field_1829, 1), "RRR", "RSR", "RRR", 'R', new class_31(class_124.field_478), 'S', new class_31(class_17.field_1945));
        }

        // Craftable Gold Ore
        if (UniTweaks.RECIPES_CONFIG.obtainable.craftableGoldOre) {
            CraftingHelper.addShapedRecipe(new class_31(class_17.field_1828, 1), "RRR", "RSR", "RRR", 'R', new class_31(class_124.field_479), 'S', new class_31(class_17.field_1945));
        }

        // Craftable Diamond Ore
        if (UniTweaks.RECIPES_CONFIG.obtainable.craftableDiamondOre) {
            CraftingHelper.addShapedRecipe(new class_31(class_17.field_1897, 1), "RRR", "RSR", "RRR", 'R', new class_31(class_124.field_477), 'S', new class_31(class_17.field_1945));
        }

        // Craftable Lapis Ore
        if (UniTweaks.RECIPES_CONFIG.obtainable.craftableLapisOre) {
            CraftingHelper.addShapedRecipe(new class_31(class_17.field_1835, 1), "RRR", "RSR", "RRR", 'R', new class_31(class_124.field_423, 1, 4), 'S', new class_31(class_17.field_1945));
        }
        
        /* Tweaked Recipes */
        // Custom Stairs per Craft
        if (UniTweaks.RECIPES_CONFIG.tweaked.stairsPerCraft != 4) {
            CraftingHelper.removeRecipe(class_17.field_1894, true);
            CraftingHelper.removeRecipe(class_17.field_1856, true);
            CraftingHelper.addShapedRecipe(new class_31(class_17.field_1894, UniTweaks.RECIPES_CONFIG.tweaked.stairsPerCraft), "X  ", "XX ", "XXX", 'X', new class_31(class_17.field_1949, 1));
            CraftingHelper.addShapedRecipe(new class_31(class_17.field_1856, UniTweaks.RECIPES_CONFIG.tweaked.stairsPerCraft), "X  ", "XX ", "XXX", 'X', new class_31(class_17.field_1948, 1));
        }

        // Custom Trapdoors per Craft
        if (UniTweaks.RECIPES_CONFIG.tweaked.trapdoorsPerCraft != 2) {
            CraftingHelper.removeRecipe(class_17.field_1913, true);
            CraftingHelper.addShapedRecipe(new class_31(class_17.field_1913, UniTweaks.RECIPES_CONFIG.tweaked.trapdoorsPerCraft), "XXX", "XXX", 'X', new class_31(class_17.field_1949, 1));
        }
    }
    
    public static void registerShapelessRecipes() {
        /* Modern Recipes */
        // Shapeless Flint and Steel Recipe
        if (UniTweaks.RECIPES_CONFIG.modern.shapelessFlintAndSteel) {
            CraftingHelper.removeRecipe(class_124.field_472, true);
            CraftingHelper.addShapelessRecipe(new class_31(class_124.field_472, 1), new class_31(class_124.field_442, 1), new class_31(class_124.field_478, 1));
        }

        // Shapeless Mushroom Stew
        if (UniTweaks.RECIPES_CONFIG.modern.shapelessMushroomStew) {
            CraftingHelper.removeRecipe(class_124.field_379, true);
            CraftingHelper.addShapelessRecipe(new class_31(class_124.field_379, 1), new class_31(class_124.field_378, 1), new class_31(class_17.field_1880, 1), new class_31(class_17.field_1881, 1));
        }

        // Shapeless Chest Minecart
        if (UniTweaks.RECIPES_CONFIG.modern.shapelessChestMinecart) {
            CraftingHelper.removeRecipe(class_124.field_414, true);
            CraftingHelper.addShapelessRecipe(new class_31(class_124.field_414, 1), new class_31(class_124.field_452, 1), new class_31(class_17.field_1895, 1));
        }

        // Shapeless Furnace Minecart
        if (UniTweaks.RECIPES_CONFIG.modern.shapelessFurnaceMinecart) {
            CraftingHelper.removeRecipe(class_124.field_415, true);
            CraftingHelper.addShapelessRecipe(new class_31(class_124.field_415, 1), new class_31(class_124.field_452, 1), new class_31(class_17.field_1850, 1));
        }

        // Shapeless Sticky Pistons
        if (UniTweaks.RECIPES_CONFIG.modern.shapelessStickyPistons) {
            CraftingHelper.removeRecipe(class_17.field_1843, true);
            CraftingHelper.addShapelessRecipe(new class_31(class_17.field_1843, 1), new class_31(class_124.field_413, 1), new class_31(class_17.field_1874, 1));
        }

        // Books require 1 leather and 3 paper
        if (UniTweaks.RECIPES_CONFIG.modern.booksRequireLeather) {
            CraftingHelper.removeRecipe(class_124.field_412);
            CraftingHelper.addShapelessRecipe(new class_31(class_124.field_412, 1), new class_31(class_124.field_411, 1), new class_31(class_124.field_411, 1), new class_31(class_124.field_411, 1), new class_31(class_124.field_406, 1));
        }

        // Wool redyeing
        if (UniTweaks.RECIPES_CONFIG.modern.woolRedyeing) {
            CraftingHelper.removeRecipe(class_17.field_1876);
            CraftingHelper.addShapedRecipe(new class_31(class_17.field_1876, 1), "SS", "SS", 'S', new class_31(class_124.field_384, 1));
            for (int i = 0; i < 16; i++) {
                CraftingHelper.addShapelessRecipe(new class_31(class_17.field_1876, 1, i), new class_31(class_17.field_1876, 1, -1), new class_31(class_124.field_423, 1, 15 - i));
            }
        }
        
        /* Obtainable Recipes */
        // Craftable Grass Block
        if (UniTweaks.RECIPES_CONFIG.obtainable.craftableGrassBlocks) {
            CraftingHelper.addShapelessRecipe(new class_31(class_17.field_1946, 1), new class_31(class_17.field_1947, 1), new class_31(class_124.field_392, 1));
        }

        // Craftable Fire
        if (UniTweaks.RECIPES_CONFIG.obtainable.craftableFire) {
            CraftingHelper.addShapelessRecipe(new class_31(class_17.field_1892, 3), new class_31(class_124.field_472, 1));
        }
        
        /* Tweaked Recipes */
        // Shapeless Jack o' Lantern
        if (UniTweaks.RECIPES_CONFIG.tweaked.shapelessJackOLantern) {
            CraftingHelper.removeRecipe(class_17.field_1908, true);
            CraftingHelper.addShapelessRecipe(new class_31(class_17.field_1908, 1), new class_31(class_17.field_1903, 1), new class_31(class_17.field_1891, 1));
        }
    }
}
