/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.unitweaks.util;

import net.danygames2014.unitweaks.UniTweaks;
import net.danygames2014.unitweaks.util.Util;
import net.minecraft.class_271;
import net.minecraft.client.Minecraft;
import org.lwjgl.input.Keyboard;

public class ModOptions {
    public static class_271 fogDensityOption;
    public static class_271 cloudsOption;
    public static class_271 fovOption;
    public static class_271 cloudHeightOption;
    public static class_271 fpsLimitOption;
    public static class_271 renderDistanceOption;
    public static class_271 brightnessOption;
    public static class_271 guiScaleOption;
    public static boolean frontView;
    public static float guiScale;
    public static float realGuiScale;
    public static float brightness;
    public static float renderDistance;
    private static final int maxRenderDistance = 32;
    public static float fpsLimit;
    public static boolean clouds;
    public static float cloudHeight;
    public static float fov;
    public static float zoomFovOffset;
    public static float photoModeFogMultiplier;
    public static float fogDensity;

    public static int getGuiScale() {
        return (int)Math.floor(realGuiScale * 8.0f);
    }

    public static int getGuiScaleDisplayValue() {
        return (int)Math.floor(guiScale * 8.0f);
    }

    public static void updateWorldLightTable(Minecraft minecraft) {
        if (minecraft == null || minecraft.field_2804 == null || minecraft.field_2804.field_216 == null) {
            return;
        }
        float brightness = ModOptions.brightness;
        float[] lightLevels = minecraft.field_2804.field_216.field_2178;
        float minimumLevel = 0.05f;
        if (minecraft.field_2804.field_216.field_2175) {
            minimumLevel = 0.1f + brightness * 0.15f;
        }
        float k = 3.0f * (1.0f - brightness);
        for (int level = 0; level <= 15; ++level) {
            float var3 = 1.0f - (float)level / 15.0f;
            lightLevels[level] = (1.0f - var3) / (var3 * k + 1.0f) * (1.0f - minimumLevel) + minimumLevel;
        }
        minecraft.field_2805.method_1537();
    }

    public static int getRenderDistanceChunks() {
        return (int)(2.0 + Math.floor(renderDistance * 30.0f));
    }

    public static int getGameRendererChunks() {
        int chunks = ModOptions.getRenderDistanceChunks();
        if (UniTweaks.USER_INTERFACE_CONFIG.videoSettingsConfig.vanillaFarValues.booleanValue() && chunks == 12) {
            chunks = 16;
        }
        return chunks;
    }

    public static void setRenderDistanceChunks(int chunks) {
        renderDistance = 0.033333335f * (float)(chunks - 2);
    }

    public static void cycleRenderDistance() {
        boolean inverted = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
        switch (ModOptions.getRenderDistanceChunks()) {
            case 2: 
            case 3: {
                ModOptions.setRenderDistanceChunks(inverted ? 12 : 4);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                ModOptions.setRenderDistanceChunks(inverted ? 2 : 8);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                ModOptions.setRenderDistanceChunks(inverted ? 4 : 12);
                break;
            }
            default: {
                ModOptions.setRenderDistanceChunks(inverted ? 8 : 2);
            }
        }
        renderDistance = Util.clamp(renderDistance, 0.0f, 1.0f);
    }

    public static int getFpsLimitValue() {
        return (int)(Math.floor(fpsLimit * 59.0f) * 5.0) + 5;
    }

    public static int getPerformanceLevel() {
        if (ModOptions.getFpsLimitValue() >= 300) {
            return 0;
        }
        return 2;
    }

    public static float getCloudHeight() {
        return Math.round(108.0f + cloudHeight * 148.0f);
    }

    public static int getFovInDegrees() {
        return Math.round(70.0f + fov * 40.0f);
    }

    public static void addZoomFovOffset(float offset) {
        zoomFovOffset = offset;
    }

    public static float getFogMultiplier() {
        if (fogDensity == 0.0f) {
            return 100.0f;
        }
        return (1.0f - Math.min(ModOptions.getFogDisplayValue(), 0.9f)) * 2.0f * photoModeFogMultiplier;
    }

    public static float getFogDisplayValue() {
        return (float)Math.round(fogDensity * 20.0f) / 20.0f;
    }

    static {
        frontView = false;
        guiScale = 0.0f;
        realGuiScale = 0.0f;
        brightness = 0.0f;
        renderDistance = 0.2f;
        fpsLimit = 0.4f;
        clouds = true;
        zoomFovOffset = 0.0f;
        photoModeFogMultiplier = 1.0f;
        fogDensity = 0.5f;
    }
}

