package net.danygames2014.unitweaks.mixin.bugfixes.boatdismountfix;

import net.danygames2014.unitweaks.UniTweaks;
import net.minecraft.class_113;
import net.minecraft.class_54;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_113.class)
public class BoatEntityMixin {

    @Inject(method = "interact", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/player/PlayerEntity;setVehicle(Lnet/minecraft/entity/Entity;)V", shift = At.Shift.AFTER))
    public void fixPositionOnDismount(class_54 player, CallbackInfoReturnable<Boolean> cir) {
        if (UniTweaks.BUGFIXES_CONFIG.boatDismountFix) {
            if (player.field_1594 == null) {
                player.method_1340(player.field_1600, player.field_1601 + 0.01, player.field_1602);
            }
        }
    }

}
