package net.danygames2014.unitweaks.mixin.bugfixes.lastdurabilityfix;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.sugar.Local;
import net.danygames2014.unitweaks.UniTweaks;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_504;
import net.minecraft.class_520;
import net.minecraft.class_54;
import net.minecraft.client.Minecraft;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(EnvType.CLIENT)
@Mixin(class_520.class)
public class SingleplayerInteractionManagerMixin extends class_504 {
    @Unique
    private boolean afterBreakHandled = false;

    public SingleplayerInteractionManagerMixin(Minecraft minecraft) {
        super(minecraft);
    }

    @Inject(method = "breakBlock", at = @At(value = "HEAD"))
    public void resetFlag(int x, int y, int z, int direction, CallbackInfoReturnable<Boolean> cir){
        afterBreakHandled = false;
    }
    
    @Inject(method = "breakBlock", at = @At(value = "INVOKE", target = "Lnet/minecraft/item/ItemStack;onRemoved(Lnet/minecraft/entity/player/PlayerEntity;)V", shift = At.Shift.BEFORE))
    public void callAfterBreak(int x, int y, int z, int direction, CallbackInfoReturnable<Boolean> cir, @Local(ordinal = 4) int var5, @Local(ordinal = 5) int var6, @Local(ordinal = 6) int var7, @Local(ordinal = 7) int var9) {
        if (!UniTweaks.BUGFIXES_CONFIG.lastDurabilityFix) {
            return;
        }
        
        if (var7 == 1 && var9 == 1) {
            class_17.field_1937[var5].method_1628(this.field_2104.field_2804, this.field_2104.field_2806, x, y, z, var6);
            afterBreakHandled = true;
        }
    }
    
    @WrapWithCondition(method = "breakBlock", at = @At(value = "INVOKE", target = "Lnet/minecraft/block/Block;afterBreak(Lnet/minecraft/world/World;Lnet/minecraft/entity/player/PlayerEntity;IIII)V"))
    public boolean cancelAfterBreak(class_17 instance, class_18 world, class_54 player, int x, int y, int z, int meta) {
        if (!UniTweaks.BUGFIXES_CONFIG.lastDurabilityFix) {
            return true;
        }
        
        return !afterBreakHandled;
    }
}
