package net.danygames2014.unitweaks.bugfixes.slabminingfix;

import net.danygames2014.unitweaks.UniTweaks;
import net.mine_diver.unsafeevents.listener.EventListener;
import net.minecraft.class_116;
import net.minecraft.class_14;
import net.minecraft.class_17;
import net.minecraft.class_339;
import net.minecraft.class_420;
import net.modificationstation.stationapi.api.event.entity.player.IsPlayerUsingEffectiveToolEvent;
import net.modificationstation.stationapi.api.event.entity.player.PlayerStrengthOnBlockEvent;

// TODO: add-stapi less variant
public class MiningListener {
    // Last tick value
    public int lastBlockId = 0;
    public int lastBlockMeta = 0;

    @EventListener
    public void isUsingEffectiveTool(IsPlayerUsingEffectiveToolEvent event) {
        // If Wooden Slab Mining Fix is not enabled, dont bother
        if (!UniTweaks.BUGFIXES_CONFIG.woodenSlabMiningFix) {
            return;
        }

        // If its already true, than making it more effective wont happen, the green light doesnt get any greener
        if (event.resultProvider.getAsBoolean()) {
            return;
        }

        // Get some values so the following code is more readable
        class_339 pos = event.blockPos;
        class_14 world = event.blockView;
        int blockId = world.method_1776(pos.field_2100, pos.field_2101, pos.field_2102);
        int blockMeta = world.method_1778(pos.field_2100, pos.field_2101, pos.field_2102);

        // If the ID and Meta matches, true
        if (blockMeta == 2 && (blockId == class_17.field_1885.field_1915 || blockId == class_17.field_1884.field_1915)) {
            event.resultProvider = () -> true;

            // If it doesnt, it might be last breaking tick and check the last values
        } else if (blockMeta == 0 && blockId == 0) {
            // If in the last tick it matched, true
            if (lastBlockMeta == 2 && (lastBlockId == class_17.field_1885.field_1915 || lastBlockId == class_17.field_1884.field_1915)) {
                event.resultProvider = () -> true;
            }
        }

        // Store last tick values
        lastBlockId = blockId;
        lastBlockMeta = blockMeta;
    }

    @EventListener
    public void playerStrengthOnBlock(PlayerStrengthOnBlockEvent event) {
        // If Wooden Slab Mining Fix is not enabled, dont bother
        if (!UniTweaks.BUGFIXES_CONFIG.woodenSlabMiningFix) {
            return;
        }

        // Get some values so the following code is more readable
        class_339 pos = event.blockPos;
        class_14 world = event.blockView;

        // If the ID and Meta matches, true
        if (world.method_1778(pos.field_2100, pos.field_2101, pos.field_2102) == 2 && (world.method_1776(pos.field_2100, pos.field_2101, pos.field_2102) == class_17.field_1885.field_1915 || world.method_1776(pos.field_2100, pos.field_2101, pos.field_2102) == class_17.field_1884.field_1915) && null != event.player.field_519.method_675()) {
            if (event.player.field_519.method_675().method_694() instanceof class_420 axe) {
                event.resultProvider = () -> axe.field_2713;
            } else if (event.player.field_519.method_675().method_694() instanceof class_116) {
                event.resultProvider = () -> 1.0F;
            }
        }
    }
}
