package net.danygames2014.unitweaks.mixin.bugfixes.furnaceconsumebucketfix;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.danygames2014.unitweaks.UniTweaks;
import net.minecraft.class_124;
import net.minecraft.class_138;
import net.minecraft.class_31;
import org.objectweb.asm.Opcodes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value = class_138.class, priority = 1100)
public class FurnaceBlockEntityMixin {
    @WrapOperation(
            method = "tick",
            at = @At(
                    value = "FIELD",
                    opcode = Opcodes.PUTFIELD,
                    target = "Lnet/minecraft/item/ItemStack;count:I"
            ),
            require = 0
    )
    public void iNotHasABucket(class_31 stack, int value, Operation<Void> original) {
        if (UniTweaks.BUGFIXES_CONFIG.furnaceConsumeBucketFix) {
            if (stack.field_753 == class_124.field_451.field_461) {
                stack.field_753 = class_124.field_449.field_461;
                stack.field_751 = 1;
            } else {
                stack.field_751 = value;
            }
        } else {
            original.call(stack, value);
        }
    }
}
