package net.danygames2014.unitweaks.mixin.bugfixes.pickblockfix;

import net.danygames2014.unitweaks.UniTweaks;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_107;
import net.minecraft.class_113;
import net.minecraft.class_124;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_27;
import net.minecraft.class_549;
import net.minecraft.class_57;
import net.minecraft.client.Minecraft;
import org.objectweb.asm.Opcodes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

import java.util.HashMap;

@Mixin(Minecraft.class)
public class MinecraftMixin {
    @Shadow
    public class_27 crosshairTarget;

    @Shadow
    public class_18 world;

    @ModifyVariable(
            method = "handlePickBlock",
            at = @At(
                    value = "FIELD",
                    target = "Lnet/minecraft/client/Minecraft;player:Lnet/minecraft/entity/player/ClientPlayerEntity;",
                    opcode = Opcodes.GETFIELD
            ),
            index = 1
    )
    public int pickBlockId(int pickedId) {
        if (UniTweaks.BUGFIXES_CONFIG.pickBlockFix) {
            switch (this.crosshairTarget.field_1983) {
                case field_789 -> {
                    return getPickBlockId(
                            pickedId,
                            world.method_1778(this.crosshairTarget.field_1984, this.crosshairTarget.field_1985, this.crosshairTarget.field_1986)
                    );
                }

                case field_790 -> {
                    return getPickEntityId(
                            pickedId,
                            this.crosshairTarget.field_1989
                    );
                }
            }
        }

        return pickedId;
    }

    @Unique
    private final HashMap<Integer, Integer> pickBlockLookupMap = new HashMap<>() {{
        put(class_17.field_1896.field_1915, class_124.field_403.field_461);
        put(class_17.field_1910.field_1915, class_124.field_428.field_461);
        put(class_17.field_1911.field_1915, class_124.field_428.field_461);
        put(class_17.field_1853.field_1915, class_124.field_448.field_461);
        put(class_17.field_1860.field_1915, class_124.field_454.field_461);
        put(class_17.field_1852.field_1915, class_124.field_447.field_461);
        put(class_17.field_1857.field_1915, class_124.field_447.field_461);
        put(class_17.field_1848.field_1915, class_124.field_392.field_461);
        put(class_17.field_1840.field_1915, class_124.field_427.field_461);
        put(class_17.field_1909.field_1915, class_124.field_426.field_461);
    }};

    @Unique
    public int getPickBlockId(int blockId, int blockMeta) {
        int itemId;
        
        if (blockId == class_17.field_1875.field_1915) {
            // Special handling for pistons
            if (blockMeta < 8) {
                itemId = class_17.field_1874.field_1915;
            } else {
                itemId = class_17.field_1843.field_1915;
            }
        } else if (pickBlockLookupMap.containsKey(blockId)){
            // Other special cases
            itemId = pickBlockLookupMap.get(blockId);
        } else {
            // If StationAPI is loaded, we need to convert the block id to an block item one
            if (FabricLoader.getInstance().isModLoaded("stationapi")) {
                itemId = convertBlockIdToItemId(blockId);
            } else {
                itemId = blockId;
            }
        }
        
        // Pack the blockId and blockMeta
        return (itemId << 4) | (blockMeta & 0xF);
    }
    
    @Unique
    public int convertBlockIdToItemId(int blockId) {
        return class_17.field_1937[blockId].asItem().field_461;
    }

    @Unique
    public int getPickEntityId(int pickedEntityId, class_57 pickedEntity) {
        if (pickedEntity instanceof class_107) {
            return class_124.field_445.field_461;
        }

        if (pickedEntity instanceof class_113) {
            return class_124.field_405.field_461;
        }

        if (pickedEntity instanceof class_549 minecart) {
            return switch (minecart.field_2275) {
                case 1 -> class_124.field_414.field_461;
                case 2 -> class_124.field_415.field_461;
                default -> class_124.field_452.field_461;
            };
        }
        return pickedEntityId;
    }

}
