package net.danygames2014.unitweaks.mixin.bugfixes.sleepingheadturningfix;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.danygames2014.unitweaks.UniTweaks;
import net.minecraft.class_40;
import net.minecraft.class_485;
import net.minecraft.class_555;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_555.class)
public class GameRendererMixin {
    @WrapOperation(method = "onFrameUpdate", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/player/ClientPlayerEntity;changeLookDirection(FF)V"))
    public void disableTurning(class_40 instance, float cursorDeltaX, float cursorDeltaY, Operation<Void> original) {
        if (!instance.method_943() || !UniTweaks.BUGFIXES_CONFIG.sleepingCameraRotationFix) {
            original.call(instance, cursorDeltaX, cursorDeltaY);
            return;
        }

        instance.field_1607 = 0;
        instance.field_1606 = getSleepingRotation(instance);
        original.call(instance, 0.0F, 0.0F);
    }

    @Unique
    public float getSleepingRotation(class_40 player) {
        if (player.field_508 != null) {
            int bedMeta = player.field_1596.method_1778(player.field_508.field_1482, player.field_508.field_1483, player.field_508.field_1484);
            int bedDirection = class_485.method_1658(bedMeta);
            switch (bedDirection) {
                case 0:
                    return 180.0F;
                case 1:
                    return 270.0F;
                case 2:
                    return 0.0F;
                case 3:
                    return 90.0F;
            }
        }

        return 0.0F;
    }
}
