package net.danygames2014.unitweaks.mixin.hooks;

import net.danygames2014.unitweaks.tweaks.morekeybinds.KeyBindingListener;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_322;
import net.minecraft.class_386;
import org.objectweb.asm.Opcodes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Mixin(class_322.class)
public class GameOptionsMixin {
    @Shadow public class_386[] allKeys;

    @Inject(method = "<init>()V", at = @At(value = "FIELD", target = "Lnet/minecraft/client/option/GameOptions;difficulty:I", ordinal = 0, opcode = Opcodes.PUTFIELD))
    public void initKeybinds(CallbackInfo ci){
        initKeybinds();
    }

    @Inject(method = "<init>(Lnet/minecraft/client/Minecraft;Ljava/io/File;)V", at = @At(value = "FIELD", target = "Lnet/minecraft/client/option/GameOptions;difficulty:I", ordinal = 0, opcode = Opcodes.PUTFIELD))
    public void initKeybinds2(CallbackInfo ci){
        initKeybinds();
    }

    @Unique
    private void initKeybinds() {
        if(FabricLoader.getInstance().isModLoaded("stationapi")){
            return;
        }
        
        List<class_386> keyBindingList = new ArrayList<>(Arrays.asList(allKeys));
        KeyBindingListener.registerKeyBindings(keyBindingList);
        allKeys = keyBindingList.toArray(new class_386[0]);
    }
}
