package net.danygames2014.unitweaks.mixin.tweaks.pressureplatesonfences;

import net.danygames2014.unitweaks.UniTweaks;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_457;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_457.class)
public class PressurePlateBlockMixin {
    @Inject(method = "canPlaceAt", at = @At("HEAD"), cancellable = true)
    public void allowPlacementOnFences(class_18 world, int x, int y, int z, CallbackInfoReturnable<Boolean> cir) {
        if (UniTweaks.TWEAKS_CONFIG.pressurePlatesOnFences) {
            if (world.method_1776(x, y - 1, z) == class_17.field_1902.field_1915) {
                cir.setReturnValue(true);
            }
        }
    }

// Old Patch Incompatible with apron
//    @Redirect(method = "neighborUpdate", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/World;method_1780(III)Z"))
//    public boolean preventBreakingOnUpdateOld(World world, int x, int y, int z) {
//        if(UniTweaks.TWEAKS_CONFIG.pressurePlatesOnFences){
//            if (world.getBlockId(x, y, z) == Block.FENCE.id) {
//                return true;
//            } else {
//                return world.method_1780(x, y, z);
//            }
//        }
//        return world.method_1780(x, y, z);
//    }

    @Inject(method = "neighborUpdate", at = @At(value = "INVOKE", target = "Lnet/minecraft/block/PressurePlateBlock;dropStacks(Lnet/minecraft/world/World;IIII)V", shift = At.Shift.BEFORE), cancellable = true)
    public void preventBreakingOnUpdate(class_18 world, int x, int y, int z, int id, CallbackInfo ci) {
        if (UniTweaks.TWEAKS_CONFIG.pressurePlatesOnFences) {
            if (world.method_1776(x, y - 1, z) == class_17.field_1902.field_1915) {
                ci.cancel();
            }
        }
    }
}
