package net.danygames2014.unitweaks.mixin.tweaks.punchsheepforwool;

import net.danygames2014.unitweaks.UniTweaks;
import net.minecraft.class_142;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_31;
import net.minecraft.class_54;
import net.minecraft.class_57;
import net.minecraft.class_613;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_613.class)
public abstract class SheepEntityMixin extends class_57 {
    @Shadow
    public abstract boolean isSheared();

    @Shadow
    public abstract void setSheared(boolean sheared);

    @Shadow
    public abstract int getColor();

    public SheepEntityMixin(class_18 world) {
        super(world);
    }

    @Inject(method = "damage", at = @At(value = "HEAD"))
    public void dropWoolOnHit(class_57 attacker, int amount, CallbackInfoReturnable<Boolean> cir) {
        if (UniTweaks.OLD_FEATURES_CONFIG.punchSheepForWool) {
            if ((attacker instanceof class_54 player) && !player.field_1596.field_180) {
                if (!isSheared()) {
                    this.setSheared(true);
                    int woolCount = field_1644.nextInt(1, 4); // 1 - 3 wool
                    for (int j = 0; j < woolCount; j++) {
                        class_142 wool = this.method_1327(new class_31(class_17.field_1876.field_1915, 1, this.getColor()), 1.0F);
                        wool.field_1603 += (field_1644.nextFloat() - field_1644.nextFloat()) * 0.1F;
                        wool.field_1604 += field_1644.nextFloat() * 0.05F;
                        wool.field_1605 += (field_1644.nextFloat() - field_1644.nextFloat()) * 0.1F;
                    }
                }
            }
        }
    }
}
