package net.danygames2014.unitweaks.mixin.tweaks.stackablechests;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.danygames2014.unitweaks.UniTweaks;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_110;
import net.minecraft.class_17;
import net.minecraft.class_18;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_110.class)
public class ChestBlockMixin {
    @WrapOperation(method = "onUse", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/World;shouldSuffocate(III)Z"))
    public boolean aBoolean(class_18 world, int x, int y, int z, Operation<Boolean> original) {
        if (UniTweaks.TWEAKS_CONFIG.stackableChests) {
            if (FabricLoader.getInstance().isModLoaded("stationapi")) {
                if (isBlockAboveChestStation(world, x, y, z)) {
                    return false;
                }
            } else {
                if (isBlockAboveChestVanilla(world, x, y, z)) {
                    return false;
                }
            }
        }
        return original.call(world, x, y, z);
    }

    @Unique
    public boolean isBlockAboveChestStation(class_18 world, int x, int y, int z) {
        return world.getBlockState(x, y, z).getBlock() instanceof class_110;
    }

    @Unique
    public boolean isBlockAboveChestVanilla(class_18 world, int x, int y, int z) {
        return world.method_1776(x, y, z) == class_17.field_1895.field_1915;
    }
}
