package net.danygames2014.unitweaks.tweaks.controls;

import net.danygames2014.unitweaks.UniTweaks;
import net.danygames2014.unitweaks.util.gui.CallbackButtonWidget;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.glasslauncher.mods.gcapi3.api.GCAPI;
import net.glasslauncher.mods.gcapi3.impl.GlassYamlFile;
import net.minecraft.class_181;
import net.minecraft.class_300;
import net.minecraft.class_32;
import net.minecraft.class_322;
import net.minecraft.class_33;
import net.minecraft.class_386;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

import java.awt.*;
import java.util.ArrayList;

@Environment(EnvType.CLIENT)
public class ControlsScreen extends class_32 {

    // Generaů
    public class_32 parent;
    public String title = "Controls";
    public String debugText = "";
    public class_322 options;
    public final class_300 translations;

    // Keybind Buttons
    public ArrayList<class_33> keybindButtons;

    // Widgets
    public KeybindListWidget keybindListWidget;
    public class_181 searchTextField;
    int searchX;
    int searchY;
    int searchWidth;
    int searchHeight;
    public class_33 doneButton;
    public class_33 stepAssist;

    // Selected
    public class_33 selectedButton;

    // Keybinds
    /**
     * ArrayList with all Keybind Entries, this is never rendered directly
     */
    private final ArrayList<KeybindEntry> keybinds = new ArrayList<>();


    /**
     * Filtered ArrayList of keybinds according to the current search term and filtration rules
     */
    public ArrayList<KeybindEntry> filteredKeybinds = new ArrayList<>();


    public ControlsScreen(class_32 parent, class_322 gameOptions) {
        this.parent = parent;
        this.options = gameOptions;
        this.translations = class_300.method_992();
        this.keybindButtons = new ArrayList<>(20);
    }


    @SuppressWarnings("unchecked")
    @Override
    public void method_119() {
        // Keybind List
        this.keybindListWidget = new KeybindListWidget(this, field_151, options);

        // Search Field
        searchTextField = new class_181(this, field_156, (this.field_152 / 2) - 110, this.field_153 - 30, 100, 20, "");
        searchTextField.method_1878(32);
        searchX = (this.field_152 / 2) - 110;
        searchY = this.field_153 - 30;
        searchWidth = 100;
        searchHeight = 20;

        // Done Button
        doneButton = new class_33(1000, (this.field_152 / 2) + 10, this.field_153 - 30, 100, 20, "Done");
        this.field_154.add(doneButton);

        // Step Assist
        stepAssist = new class_33(1001, (this.field_152 / 2) + 10, 10, 100, 20, "Step Assist: OFF");
        if (this.field_151.field_2804 == null) {
            stepAssist.field_1374 = false;
        }
        this.field_154.add(stepAssist);

        // Init Keybinds
        initKeybinds();

        // Initial Keybind Filter
        filterKeybinds();

        // Refresh Key Labels
        refreshKeyLabels();

        // Refresh Button Labels
        refreshButtonLabels();
    }

    /**
     * Initializes keybinds ArrayList with entries of all keybinds
     */
    public void initKeybinds() {
        keybindButtons.clear();
        keybinds.clear();

        for (int i = 0; i < options.field_1478.length; i++) {
            class_386 keyBinding = options.field_1478[i];

            // Init Buttons
            class_33 keyButton = new class_33(i, -1, -1, 100, 20, Keyboard.getKeyName(keyBinding.field_2381));

            keybinds.add(new KeybindEntry(this, keyButton, keyBinding));
            this.keybindButtons.add(keyButton);
        }
    }


    /**
     * Filters keybinds based on search and filtration rules into the filteredKeybinds ArrayList
     */
    public void filterKeybinds() {
        filteredKeybinds.clear();

        String searchTerm = searchTextField.method_1876().toLowerCase();

        for (var item : keybinds) {
            if (translations.method_993(item.keyBinding.field_2380).toLowerCase().contains(searchTerm)) {
                filteredKeybinds.add(item);
            }
        }
    }

    /**
     * Refreshes keybind labels and if there is a conflict with any other key, colors them red
     */
    public void refreshKeyLabels() {
        for (KeybindEntry keybindEntry : filteredKeybinds) {
            String formatting = "§f";

            // Look for conflicts
            for (int j = 0; j < options.field_1478.length; j++) {
                if (!(options.field_1478[j].field_2380.equals(keybindEntry.keyBinding.field_2380)) && (options.field_1478[j].field_2381 == keybindEntry.keyBinding.field_2381)) {
                    // Im sorry for this

                    // Disable checking for dismount
                    if (!options.field_1478[j].field_2380.equals("key.unitweaks.dismount") && !keybindEntry.keyBinding.field_2380.equals("key.unitweaks.dismount")) {
                        // Disable checking for unbound keys
                        if (options.field_1478[j].field_2381 != Keyboard.KEY_NONE || keybindEntry.keyBinding.field_2381 != Keyboard.KEY_NONE) {
                            formatting = "§c";
                        }
                    }
                }
            }

            keybindEntry.keyButton.field_1372 = formatting + Keyboard.getKeyName(keybindEntry.keyBinding.field_2381) + "§f";
        }
    }

    public void refreshButtonLabels() {
        if (UniTweaks.FEATURES_CONFIG.stepAssist) {
            stepAssist.field_1372 = "Step Assist: ON";
        } else {
            stepAssist.field_1372 = "Step Assist: OFF";
        }
    }


    // Interaction Events

    /**
     * @author calmilamsy
     * Scrolling
     */
    @Override
    public void method_131() {
        super.method_131();
        float dWheel = Mouse.getDWheel();
        if (dWheel != 0) {
            keybindListWidget.scroll(-(dWheel / 10));
//            System.out.println(keybindListWidget.getScroll());
        }
    }

    @Override
    protected void method_124(int mouseX, int mouseY, int button) {
        super.method_124(mouseX, mouseY, button);

        selectedButton = null;
        refreshKeyLabels();

        searchTextField.method_1879(mouseX, mouseY, button);
        if (button == 1) {
            filterKeybinds();
        }

        mouseClickedKeybind(mouseX, mouseY, button);
    }

    public void mouseClickedKeybind(int mouseX, int mouseY, int mouseButton) {
        // Check if left mouse button
        if (mouseButton != 0) {
            return;
        }

        // Out Of Bounds Check
        if (mouseY < 40 || mouseY > (this.field_153 - 40)) {
            return;
        }

        // Loop over filtered keybinds
        for (var keybindEntry : filteredKeybinds) {
            class_33 button = keybindEntry.keyButton;
            if (button.method_1189(field_151, mouseX, mouseY)) {
                if (keybindListWidget.getScroll() < ((button.field_1373 * 20) + 24)) {
                    field_151.field_2766.method_2009("random.click", 1.0F, 1.0F);
                    method_120(button);
//                    System.out.println("Clicked button " + button.text + " with id : " + button.id + ", y : " + button.y);
                    return;
                } else {
//                    System.out.println("Ignored button " + button.text + " with id : " + button.id + ", y : " + button.y);
                }
            }
        }
    }

    @Override
    protected void method_117(char character, int keyCode) {
        // If search field focused, send the keyCode there
        if (searchTextField.field_2420) {
            searchTextField.method_1877(character, keyCode);
            filterKeybinds();
            return;
        }

        for (var item : filteredKeybinds) {
            if (item.keyButton == selectedButton) {
                // If key is escape, unbind the key
                if (keyCode == Keyboard.KEY_ESCAPE) {
                    item.keyBinding.field_2381 = Keyboard.KEY_NONE;
                } else {
                    item.keyBinding.field_2381 = keyCode;
                }

                // Binding done, unselect button and refrsh label
                selectedButton = null;
                refreshKeyLabels();

                // Save and Return
                options.method_1231();
                return;
            }
        }
    }

    // Button Clik
    @Override
    protected void method_120(class_33 button) {
        if (button.field_1373 == 1000) { // Done
            field_151.method_2112(this.parent);

        } else if (button.field_1373 == 1001) { // Step Assist
            UniTweaks.FEATURES_CONFIG.stepAssist = !UniTweaks.FEATURES_CONFIG.stepAssist;
//            JsonObject jsonObject = new JsonObject();
//            jsonObject.put("stepAssist", new JsonPrimitive(UniTweaks.FEATURES_CONFIG.stepAssist));

            GlassYamlFile yamlFile = new GlassYamlFile();
            yamlFile.set("stepAssist", UniTweaks.FEATURES_CONFIG.stepAssist);

            try {
                GCAPI.reloadConfig("unitweaks:features", yamlFile);
            } catch (Exception e) {
                UniTweaks.LOGGER.error("Failed to reload config", e);
            }
            refreshButtonLabels();

        } else if (keybindButtons.contains(button)) { // Keybind
            selectedButton = button;
            button.field_1372 = "> " + button.field_1372 + " <";
        } else if (button instanceof CallbackButtonWidget callbackButton) {
            callbackButton.doAction();
        }
    }

    // Rendering
    @Override
    public void method_118(int mouseX, int mouseY, float delta) {
        this.method_134();
        keybindListWidget.method_1256(mouseX, mouseY, delta);
        this.method_1937(field_156, title, 10, 10, Color.white.getRGB());
        this.method_1937(field_156, debugText, 10, 20, Color.white.getRGB());
        searchTextField.method_1883();
        doneButton.method_1186(field_151, mouseX, mouseY);
        stepAssist.method_1186(field_151, mouseX, mouseY);
    }

    @SuppressWarnings("unchecked")
    public static class KeybindEntry {
        public final class_33 keyButton;
        public class_386 keyBinding;
        public class_33 resetButton;
        public final int defaultKeybind;
        public final ControlsScreen parent;

        public KeybindEntry(ControlsScreen parent, class_33 keyButton, class_386 keyBinding) {
            this.parent = parent;
            this.keyButton = keyButton;
            this.keyBinding = keyBinding;
            this.defaultKeybind = DefaultKeys.getDefaultKeybind(keyBinding);
            this.init();
        }

        public void init() {
            this.resetButton = new CallbackButtonWidget(-1, -1, 50, 20, "Reset", this::resetToDefault);
            this.parent.field_154.add(resetButton);
        }

        private void resetToDefault(Void unused) {
            this.keyBinding.field_2381 = this.defaultKeybind;
            this.parent.refreshKeyLabels();
            this.parent.options.method_1231();
        }
    }
}

