package net.danygames2014.uniwrench.network;

import net.danygames2014.uniwrench.init.ItemListener;
import net.danygames2014.uniwrench.item.WrenchBase;
import net.danygames2014.uniwrench.mixin.ServerPlayerAccessor;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_169;
import net.minecraft.class_240;
import net.minecraft.class_31;
import net.minecraft.class_69;
import net.modificationstation.stationapi.api.network.packet.IdentifiablePacket;
import net.modificationstation.stationapi.api.util.Identifier;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class WrenchModeC2SPacket extends class_169 implements IdentifiablePacket {
    private static final Identifier identifier = ItemListener.NAMESPACE.id("wrench_mode");
    private int wrenchMode;
    private int slot;

    public WrenchModeC2SPacket() {
    }

    public WrenchModeC2SPacket(int wrenchMode, int slot) {
        this.wrenchMode = wrenchMode;
        this.slot = slot;
    }

    @Override
    public void method_806(DataInputStream stream) {
        try {
            this.wrenchMode = stream.readInt();
            this.slot = stream.readInt();
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void method_807(DataOutputStream stream) {
        try {
            stream.writeInt(this.wrenchMode);
            stream.writeInt(this.slot);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void method_808(class_240 networkHandler) {
        System.out.println("Packet Received = Wrench Mode : " + this.wrenchMode);

        handleServer(networkHandler);
    }

    @Environment(EnvType.SERVER)
    public void handleServer(class_240 networkHandler){
        ServerPlayerAccessor accessor = (ServerPlayerAccessor) networkHandler;
        class_69 player = accessor.getServerPlayer();

        class_31 stack  = player.field_519.field_745[this.slot];
        if (stack != null && stack.method_694() instanceof WrenchBase wrench) {
            wrench.setWrenchMode(stack, this.wrenchMode);
        }
    }

    @Override
    public int method_798() {
        return 8;
    }

    @Override
    public Identifier getId() {
        return identifier;
    }

    public static void register() {
        IdentifiablePacket.register(identifier, false, true, WrenchModeC2SPacket::new);
    }
}
