package net.danygames2014.uniwrench.mixin;

import net.danygames2014.uniwrench.api.Wrenchable;
import net.danygames2014.uniwrench.item.WrenchBase;
import net.minecraft.class_18;
import net.minecraft.class_31;
import net.minecraft.class_504;
import net.minecraft.class_54;
import net.modificationstation.stationapi.api.block.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_504.class)
public abstract class InteractionManagerMixin {
    @Inject(method = "interactBlock", at = @At(value = "HEAD"), cancellable = true)
    public void flipActions(class_54 player, class_18 world, class_31 stack, int x, int y, int z, int side, CallbackInfoReturnable<Boolean> cir) {
        BlockState state = world.getBlockState(x, y, z);

        if (state.isAir() || stack == null) {
            return;
        }

        if (stack.method_694() instanceof WrenchBase wrench) {
            if (!wrench.method_444(stack, player, world, x, y, z, side)) {
                state.getBlock().method_1608(world, x, y, z, player);
            }
            cir.cancel();
        }
    }
}
