package net.danygames2014.uniwrench.item;

import net.danygames2014.uniwrench.UniWrench;
import net.danygames2014.uniwrench.api.WrenchFunction;
import net.danygames2014.uniwrench.api.WrenchMode;
import net.danygames2014.uniwrench.api.Wrenchable;
import net.danygames2014.uniwrench.api.WrenchableBlockRegistry;
import net.danygames2014.uniwrench.network.WrenchModeC2SPacket;
import net.danygames2014.uniwrench.util.HotbarTooltipHelper;
import net.danygames2014.uniwrench.util.MathUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_31;
import net.minecraft.class_54;
import net.minecraft.class_8;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.client.item.CustomTooltipProvider;
import net.modificationstation.stationapi.api.item.StationItemNbt;
import net.modificationstation.stationapi.api.network.packet.PacketHelper;
import net.modificationstation.stationapi.api.template.item.TemplateItem;
import net.modificationstation.stationapi.api.util.Identifier;

import java.util.ArrayList;

public class WrenchBase extends TemplateItem implements CustomTooltipProvider {
    private final ArrayList<WrenchMode> wrenchModes;

    public WrenchBase(Identifier identifier) {
        super(identifier);
        this.method_460(1);
        wrenchModes = new ArrayList<>();
    }

    // Wrench Modes
    @Environment(EnvType.CLIENT)
    public void cycleWrenchMode(class_31 itemStack, int direction, class_54 player) {
        if (this.wrenchModes == null || this.wrenchModes.isEmpty()) {
            return;
        }

        this.setWrenchMode(itemStack, MathUtil.clamp(this.readMode(itemStack) + direction, 0, this.wrenchModes.size() - 1));
        //player.method_490("Wrench Mode changed : " + this.getWrenchMode(itemStack).getTranslatedName());
        HotbarTooltipHelper.setTooltip("Wrench Mode: " + this.getWrenchMode(itemStack).getTranslatedName(), 40);
        if (player.field_1596.field_180) {
            for (int i = 0; i < player.field_519.field_745.length; i++) {
                if (player.field_519.field_745[i] == itemStack) {
                    PacketHelper.send(new WrenchModeC2SPacket(readMode(itemStack), i));
                }
            }
        }
    }

    public WrenchMode getWrenchMode(class_31 stack) {
        return this.wrenchModes.get(this.readMode(stack));
    }

    public void setWrenchMode(class_31 stack, int mode) {
        this.writeMode(stack, mode);
    }

    public void addWrenchMode(WrenchMode wrenchMode) {
        if (wrenchMode == null) {
            UniWrench.LOGGER.fatal("WRENCH MODE IS NULL! The game will now crash because fuck you (:");
        }

        // I know this can be null, and if it is i want it to crash because that means i can cry over race conditions again :)))
        //noinspection DataFlowIssue
        UniWrench.LOGGER.info("Adding Wrench Mode {} to {}", wrenchMode.name, this.method_469());

        if (!this.wrenchModes.contains(wrenchMode)) {
            this.wrenchModes.add(wrenchMode);
        }
    }

    // Wrench Actions
    @Override
    public boolean method_444(class_31 stack, class_54 player, class_18 world, int x, int y, int z, int side) {
        class_17 block = world.getBlockState(x, y, z).getBlock();
        WrenchMode wrenchMode = this.getWrenchMode(stack);

        // First see if the block has the Wrenchable interface
        if (block instanceof Wrenchable wrenchable) {
            // If its Wrenchable, try to wrench it
            boolean wrenched = wrenchable.wrenchRightClick(stack, player, player.method_1373(), world, x, y, z, side, wrenchMode);

            // If this returns true, ignore all further actions, if not, continue
            if (wrenched) {
                return true;
            }

            // Check if any Right Click actions exist for this block
        } else if (WrenchableBlockRegistry.doRightClickActionsExist(block)) {
            // If they exist, loop thru them
            for (WrenchFunction action : WrenchableBlockRegistry.getRightClickActions(block)) {
                // If any of them returns true, ignore all futher actions
                if (action.apply(stack, player, player.method_1373(), world, x, y, z, side, wrenchMode)) {
                    return true;
                }
            }
        }

        // If no actions existed, or they all returned false, trigger the wrench action
        if (wrenchRightClick(stack, player, player.method_1373(), world, x, y, z, side, wrenchMode)) {
            return true;
        }

        // If no previus actions returned true, try the wrench mode action
        return wrenchMode.wrenchRightClick(stack, player, player.method_1373(), world, x, y, z, side, wrenchMode);
    }

    @Override
    public boolean preMine(class_31 stack, BlockState state, int x, int y, int z, int side, class_54 player) {
        class_17 block = state.getBlock();
        WrenchMode wrenchMode = this.getWrenchMode(stack);

        // First see if the block has the Wrenchable interface
        if (block instanceof Wrenchable wrenchable) {
            // If its Wrenchable, try to wrench it
            boolean wrenched = wrenchable.wrenchLeftClick(stack, player, player.method_1373(), player.field_1596, x, y, z, side, wrenchMode);

            // If this returns true, ignore all further actions, if not, continue
            if (wrenched) {
                return false;
            }

            // Check if any Left Click actions exist for this block
        } else if (WrenchableBlockRegistry.doRightClickActionsExist(state.getBlock())) {
            // If they exist, loop thru them
            for (WrenchFunction action : WrenchableBlockRegistry.getLeftClickActions(block)) {
                // If any of them returns true, ignore all futher actions
                if (action.apply(stack, player, player.method_1373(), player.field_1596, x, y, z, side, wrenchMode)) {
                    return false;
                }
            }

        }

        // If no actions existed, or they all returned false, trigger the wrench action
        if (wrenchLeftClick(stack, player, player.method_1373(), player.field_1596, x, y, z, side, wrenchMode)) {
            return false;
        }

        // If no previus actions returned true, try the wrench mode action
        return !wrenchMode.wrenchLeftClick(stack, player, player.method_1373(), player.field_1596, x, y, z, side, wrenchMode);
    }

    // API Methods
    /**
     * This method will be fired when the block is right-clicked with a wrench
     * @param stack ItemStack of the wrench
     * @param player Player which right-clicked the block
     * @param isSneaking If the player is sneaking
     * @param world The world in which this happened
     * @param x x-coordinate of the right-clicked block
     * @param y y-coordinate of the right-clicked block
     * @param z z-coordinate of the right-clicked block
     * @param side Side of the block which was right-clicked
     * @param wrenchMode The current wrench mode of the wrench
     * @return If the action was susccesfull, returning true will cancel the onUse method on the block aswell as all further actions
     */
    public boolean wrenchRightClick(class_31 stack, class_54 player, boolean isSneaking, class_18 world, int x, int y, int z, int side, WrenchMode wrenchMode) {
        return false;
    }

    /**
     * This method will be fired when the block is left-clicked with a wrench
     * @param stack ItemStack of the wrench
     * @param player Player which left-clicked the block
     * @param isSneaking If the player is sneaking
     * @param world The world in which this happened
     * @param x x-coordinate of the left-clicked block
     * @param y y-coordinate of the left-clicked block
     * @param z z-coordinate of the left-clicked block
     * @param side Side of the block which was left-clicked
     * @param wrenchMode The current wrench mode of the wrench
     * @return If the action was susccesfull, returning true will cancel all further actions
     */
    public boolean wrenchLeftClick(class_31 stack, class_54 player, boolean isSneaking, class_18 world, int x, int y, int z, int side, WrenchMode wrenchMode) {
        return false;
    }

    // Tooltip
    public String[] getTooltip(class_31 stack, String originalTooltip) {
        if (this.wrenchModes == null || this.wrenchModes.isEmpty()) {
            return new String[]{
                    originalTooltip
            };
        }
        return new String[]{
                originalTooltip,
                "Mode : " + this.getWrenchMode(stack).getTranslatedName()
        };
    }

    // NBT
    public int readMode(class_31 itemStack) {
        class_8 nbt = ((StationItemNbt) itemStack).getStationNbt();
        if (!nbt.method_1023("wrench_mode")) {
            this.writeMode(itemStack, 0);
        }
        return MathUtil.clamp(nbt.method_1027("wrench_mode"), 0, this.wrenchModes.size() - 1);
    }

    public void writeMode(class_31 itemStack, int mode) {
        class_8 nbt = ((StationItemNbt) itemStack).getStationNbt();
        nbt.method_1015("wrench_mode", MathUtil.clamp(mode, 0, this.wrenchModes.size() - 1));
    }
}
