package net.danygames2014.uniwrench.api;

import com.mojang.datafixers.util.Function9;
import net.minecraft.class_18;
import net.minecraft.class_31;
import net.minecraft.class_54;

/**
 * A function representation of the {@link Wrenchable} interface
 * If the interface is implemented, it takes a precedence
 * <p>The Signature is as follows <code>(stack, player, isSneaking, world, x, y, z, side, wrenchMode)</code>
 */
public interface WrenchFunction extends Function9<class_31, class_54, Boolean, class_18, Integer, Integer, Integer, Integer, WrenchMode, Boolean> {

    /**
     * @param stack      ItemStack of the wrench
     * @param player     Player which wrenched the block
     * @param isSneaking If the player is sneaking
     * @param world      The world in which this happened
     * @param x          x-coordinate of the block
     * @param y          y-coordinate of the block
     * @param z          z-coordinate of the block
     * @param side       Side of the block which was wrenched
     * @param wrenchMode The current wrench mode of the wrench
     * @return Whether the action was succesfull, this will cancel all further actions
     */
    @Override
    Boolean apply(class_31 stack, class_54 player, Boolean isSneaking, class_18 world, Integer x, Integer y, Integer z, Integer side, WrenchMode wrenchMode);
}
