package net.danygames2014.uniwrench.mixin;

import net.danygames2014.uniwrench.init.ItemListener;
import net.danygames2014.uniwrench.item.WrenchBase;
import net.danygames2014.uniwrench.util.MathUtil;
import net.minecraft.class_136;
import net.minecraft.class_31;
import net.minecraft.class_54;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_136.class)
public abstract class PlayerInventoryMixin {
    @Shadow
    public abstract class_31 getSelectedItem();

    @Shadow
    public class_54 player;

    @Inject(method = "scrollInHotbar", at = @At("HEAD"), cancellable = true)
    public void wrenchScroll(int scrollDirection, CallbackInfo ci) {
        if (this.getSelectedItem() != null && this.getSelectedItem().method_694() instanceof WrenchBase wrench && player.method_1373()) {
            wrench.cycleWrenchMode(this.getSelectedItem(), MathUtil.clamp(scrollDirection, -1, 1), this.player);

            ci.cancel();
        }
    }
}
