/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.uniwrench.item;

import java.util.ArrayList;
import net.danygames2014.uniwrench.UniWrench;
import net.danygames2014.uniwrench.api.WrenchFunction;
import net.danygames2014.uniwrench.api.WrenchMode;
import net.danygames2014.uniwrench.api.Wrenchable;
import net.danygames2014.uniwrench.api.WrenchableBlockRegistry;
import net.danygames2014.uniwrench.network.WrenchModeC2SPacket;
import net.danygames2014.uniwrench.util.HotbarTooltipHelper;
import net.danygames2014.uniwrench.util.MathUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_169;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_31;
import net.minecraft.class_54;
import net.minecraft.class_57;
import net.minecraft.class_8;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.client.item.CustomTooltipProvider;
import net.modificationstation.stationapi.api.network.packet.PacketHelper;
import net.modificationstation.stationapi.api.template.item.TemplateItem;
import net.modificationstation.stationapi.api.util.Identifier;

public class WrenchBase
extends TemplateItem
implements CustomTooltipProvider {
    private final ArrayList<WrenchMode> wrenchModes;
    protected int usageDelay;

    public WrenchBase(Identifier identifier) {
        super(identifier);
        this.method_460(1);
        this.wrenchModes = new ArrayList();
        this.usageDelay = 0;
    }

    @Environment(value=EnvType.CLIENT)
    public void cycleWrenchMode(class_31 itemStack, int direction, class_54 player) {
        if (this.wrenchModes == null || this.wrenchModes.isEmpty()) {
            return;
        }
        this.setWrenchMode(itemStack, MathUtil.clamp(this.readMode(itemStack) + direction, 0, this.wrenchModes.size() - 1));
        HotbarTooltipHelper.setTooltip("Wrench Mode: " + this.getWrenchMode(itemStack).getTranslatedName(), 40);
        if (player.field_1596.field_180) {
            for (int i = 0; i < player.field_519.field_745.length; ++i) {
                if (player.field_519.field_745[i] != itemStack) continue;
                PacketHelper.send((class_169)new WrenchModeC2SPacket(this.readMode(itemStack), i));
            }
        }
    }

    public WrenchMode getWrenchMode(class_31 stack) {
        return this.wrenchModes.get(this.readMode(stack));
    }

    public void setWrenchMode(class_31 stack, int mode) {
        this.writeMode(stack, mode);
    }

    public void addWrenchMode(WrenchMode wrenchMode) {
        if (wrenchMode == null) {
            UniWrench.LOGGER.error("Tried to add a null wrench mode to wrench {}", (Object)((Object)((Object)this)).toString());
            return;
        }
        UniWrench.LOGGER.info("Adding Wrench Mode {} to {}", (Object)wrenchMode.name, (Object)((Object)((Object)this)).toString());
        if (this.wrenchModes.contains(wrenchMode)) {
            UniWrench.LOGGER.error("Tried to add a duplicate Wrench mode {}", (Object)wrenchMode.name);
            return;
        }
        this.wrenchModes.add(wrenchMode);
    }

    public boolean method_444(class_31 stack, class_54 player, class_18 world, int x, int y, int z, int side) {
        if (this.getDelay(stack) > 0) {
            return false;
        }
        class_17 block = world.getBlockState(x, y, z).getBlock();
        WrenchMode wrenchMode = this.getWrenchMode(stack);
        if (block instanceof Wrenchable) {
            Wrenchable wrenchable = (Wrenchable)block;
            boolean wrenched = wrenchable.wrenchRightClick(stack, player, player.method_1373(), world, x, y, z, side, wrenchMode);
            if (wrenched) {
                this.setDelay(stack, this.usageDelay);
                return true;
            }
        } else if (WrenchableBlockRegistry.doRightClickActionsExist(block)) {
            for (WrenchFunction action : WrenchableBlockRegistry.getRightClickActions(block)) {
                if (!action.apply(stack, player, player.method_1373(), world, x, y, z, side, wrenchMode).booleanValue()) continue;
                this.setDelay(stack, this.usageDelay);
                return true;
            }
        }
        if (this.wrenchRightClick(stack, player, player.method_1373(), world, x, y, z, side, wrenchMode)) {
            this.setDelay(stack, this.usageDelay);
            return true;
        }
        if (wrenchMode.wrenchRightClick(stack, player, player.method_1373(), world, x, y, z, side, wrenchMode)) {
            this.setDelay(stack, this.usageDelay);
            return true;
        }
        return false;
    }

    public boolean preMine(class_31 stack, BlockState state, int x, int y, int z, int side, class_54 player) {
        if (this.getDelay(stack) > 0) {
            return false;
        }
        class_17 block = state.getBlock();
        WrenchMode wrenchMode = this.getWrenchMode(stack);
        if (block instanceof Wrenchable) {
            Wrenchable wrenchable = (Wrenchable)block;
            boolean wrenched = wrenchable.wrenchLeftClick(stack, player, player.method_1373(), player.field_1596, x, y, z, side, wrenchMode);
            if (wrenched) {
                this.setDelay(stack, this.usageDelay);
                return false;
            }
        } else if (WrenchableBlockRegistry.doRightClickActionsExist(state.getBlock())) {
            for (WrenchFunction action : WrenchableBlockRegistry.getLeftClickActions(block)) {
                if (!action.apply(stack, player, player.method_1373(), player.field_1596, x, y, z, side, wrenchMode).booleanValue()) continue;
                this.setDelay(stack, this.usageDelay);
                return false;
            }
        }
        if (this.wrenchLeftClick(stack, player, player.method_1373(), player.field_1596, x, y, z, side, wrenchMode)) {
            this.setDelay(stack, this.usageDelay);
            return false;
        }
        if (wrenchMode.wrenchLeftClick(stack, player, player.method_1373(), player.field_1596, x, y, z, side, wrenchMode)) {
            this.setDelay(stack, this.usageDelay);
            return false;
        }
        return true;
    }

    public boolean wrenchRightClick(class_31 stack, class_54 player, boolean isSneaking, class_18 world, int x, int y, int z, int side, WrenchMode wrenchMode) {
        return false;
    }

    public boolean wrenchLeftClick(class_31 stack, class_54 player, boolean isSneaking, class_18 world, int x, int y, int z, int side, WrenchMode wrenchMode) {
        return false;
    }

    public String[] getTooltip(class_31 stack, String originalTooltip) {
        if (this.wrenchModes == null || this.wrenchModes.isEmpty()) {
            return new String[]{originalTooltip};
        }
        return new String[]{originalTooltip, "Mode : " + this.getWrenchMode(stack).getTranslatedName()};
    }

    public int readMode(class_31 itemStack) {
        class_8 nbt = itemStack.getStationNbt();
        if (!nbt.method_1023("wrench_mode")) {
            this.writeMode(itemStack, 0);
        }
        return MathUtil.clamp(nbt.method_1027("wrench_mode"), 0, this.wrenchModes.size() - 1);
    }

    public void writeMode(class_31 itemStack, int mode) {
        class_8 nbt = itemStack.getStationNbt();
        nbt.method_1015("wrench_mode", MathUtil.clamp(mode, 0, this.wrenchModes.size() - 1));
    }

    public WrenchBase setUsageDelay(int usageDelay) {
        this.usageDelay = usageDelay;
        return this;
    }

    public void method_454(class_31 stack, class_18 world, class_57 entity, int slot, boolean selected) {
        super.method_454(stack, world, entity, slot, selected);
        int delay = this.getDelay(stack);
        if (delay > 0) {
            this.setDelay(stack, delay - 1);
        }
    }

    public int getDelay(class_31 itemStack) {
        return itemStack.getStationNbt().method_1027("delay");
    }

    public void setDelay(class_31 itemStack, int delay) {
        itemStack.getStationNbt().method_1015("delay", delay);
    }
}

